import os
import pandas as pd

from modules.experiments.das_experiments import DASExperiment


class Tuner(DASExperiment):
    def __init__(self, n_runs=10, N=1000, noise_type="Gauss", output_path = "./logs/tuning", pruning=False):
        super().__init__(n_runs, N, noise_type, output_path, pruning)
        self.verbose = False


    def get_output(self, params):
        alpha = params['alpha']
        gamma = params['gamma']
        n_cv = params['n_cv']
        return self.output_path + f"/a{alpha}-g{gamma}-cv{n_cv}.csv"


    def run_experiment(self, params_grid):
        """Run n_run experiments for each combination of parameters and log the results"""
        logs_dict = dict()
        k = 1
        for params in params_grid:
            output = self.get_output(params)
            d, s0, alpha, gamma, n_cv = self.get_params(params)
            params_logs = self.get_params_logs(d, s0, alpha, gamma, n_cv)
            
            if output in logs_dict:
                logs = logs_dict[output]
            else:
                logs = list()

            logs.append(params_logs)
            df_logs = pd.DataFrame(data=logs, columns=self.columns)
            # if not os.path.exists(output):
            df_logs.to_csv(output, mode='w')
            # else:
            #     df_logs.to_csv(output, mode='a', header=False)
                
            logs_dict[output] = logs

            print(f"Completed run {k}/{len(params_grid)}")
            k += 1