import sys
from sklearn.model_selection import ParameterGrid
from modules.experiments.tuner import Tuner

base_folder = "/home/francescom/Research/DAS-Extension/src"

output_path = base_folder + sys.argv[1] 
noise_type = sys.argv[2]
pruning = sys.argv[3] == "True"
exp_manager = Tuner(n_runs=10, noise_type=noise_type, output_path=output_path, pruning=pruning)
params_grid = ParameterGrid(
    {
        'alpha' : [0.001, 0.01, 0.1, 1],
        'gamma' : [0.001, 0.01, 0.1, 1],
        'n_cv' : [3, 5],
        'd' : [10, 20],
        's0' : ['d', '4d']
    }
)

exp_manager.run_experiment(params_grid)