export WANDB_API_KEY=<YOUR WANDB API KEY>
export HF_TOKEN=<YOUR HF TOKEN>
export HF_HOME=<YOUR HF HOME>
export PYTORCH_CUDA_ALLOC_CONF=expandable_segments:True
module load cuda/12.1.1
module load Python3/3.10.10

source <YOUR VENV PATH>

# Hyperparameters described in the paper 
LR=1e-4
EPS=1e-3

PERTURBATION=unbiased-p4
# PERTURBATION=unbiased-p3
ZO_BATCH_SIZE=1 

# PERTURBATION=normal  
# ZO_BATCH_SIZE=3

UNBIASED_CLASS=zipf
UNBIASED_PARAM=1.5
# UNBIASED_CLASS=geometric
# UNBIASED_PARAM=0.5
PERTURBATION_MODE=one_side

srun python3 ./zo-bench/run.py --prompt_tuning --num_virtual_tokens=10 --prompt_init_by_real_tokens --model_name=facebook/opt-1.3b --task_name=SST2 --output_dir=<YOUR OUTPUT DIR> --overwrite_output_dir --no_reparam --num_train_epochs=5 --per_device_train_batch_size=16 --load_best_model_at_end --evaluation_strategy=steps --save_strategy=steps --save_total_limit=1 --eval_steps=1000 --max_steps=40000 --logging_steps=10 --num_eval=1000 --num_train=1000 --num_dev=500 --train_as_classification --perturbation_mode=$PERTURBATION_MODE --trainer=zo_sgd --optimizer=sgd --train_set_seed=0 --lr_scheduler_type=constant --eval_steps=500 --save_steps=500 --learning_rate=$LR --weight_decay=0 --zo_eps=$EPS --perturbation=$PERTURBATION --unbiased_class $UNBIASED_CLASS --unbiased_param=$UNBIASED_PARAM --wandb_project=zo-perturbation-unbiased --zo_batch_size=$ZO_BATCH_SIZE