"""
Bernoulli estimator implementation.
"""

import numpy as np
from .base import GradEstimator

class BernoulliEstimator(GradEstimator):
    """Bernoulli estimator implementation.
    
    This estimator uses Bernoulli distributed noise.
    """
    
    def generate_noise(self, x):
        """Generate Bernoulli noise.
        
        Args:
            x (numpy.ndarray): The point at which to estimate the gradient.
            
        Returns:
            numpy.ndarray: The noise vector.
        """
        return -1 + 2 * np.random.binomial(n=1, p=0.5, size=x.shape) 