"""
Coordinate estimator implementation.
"""

import numpy as np
from .base import GradEstimator

class CoordinateEstimator(GradEstimator):
    """Coordinate estimator implementation.
    
    This estimator uses coordinate-wise noise.
    """
    
    def generate_noise(self, x):
        """Generate coordinate-wise noise.
        
        Args:
            x (numpy.ndarray): The point at which to estimate the gradient.
            
        Returns:
            numpy.ndarray: The noise vector.
        """
        v = np.zeros_like(x)
        ind = np.random.choice(len(x))
        v[ind] = 1.0
        return v 