## Function to check assumptions (A1) and (A3)

check_assumptions_A <- function(A, B, parents){

  d <- ncol(B)

  ## Compute C
  C <- t(solve((diag(d) - B), A))

  ## Verify A1
  assA1 <- qr(C[,parents])$rank == length(parents)

  ## Verify A3
  sets_S <- combn(1:d, length(parents), simplify=FALSE)
  parent_ind <- sapply(sets_S, function(S) sum(sort(S) == sort(parents)) == length(S))
  sets_S <- sets_S[!parent_ind]

  assA3_vec <- rep(FALSE, length(sets_S))
  for(k in 1:length(sets_S)){
    unionS <- union(parents, sets_S[[k]])
    assA3_vec[k] <- (qr(C[,unionS])$rank > length(parents) | qr(C[,sets_S[[k]]])$rank < length(parents))
  }
  assA3 <- sum(assA3_vec) == length(assA3_vec)

  return(list(assA1=assA1,
              assA3=assA3))

}
