# Implementation of K-klass estimators

K_class <- function(k,Z,Y,n,P_A){
  Wk <- t(Z) %*% ((1-k)*diag(n)+k* P_A )  %*%Z
  a <- solve(Wk, t(Z)) %*% ( (1-k)*diag(n) + k*P_A ) %*% Y 
  return(a)
}

LIML_k <- function(Y,X,n,P_A){
  M_A = diag(n) - P_A
  W = t(cbind(Y,X)) %*% M_A %*% cbind(Y,X)
  W_1 = t(cbind(Y,X)) %*% cbind(Y,X)
  return(min(abs(eigen(W_1 %*% solve(W), only.values=TRUE)$values)))
}

liml <- function(X, Y, P_I, n){
  kpar <- LIML_k(Y, X, n=n, P_A=P_I)
  return(K_class(kpar, X, Y, n=n, P_A=P_I))
}
