linear_DAG_model_sparse <- function(d=50, m=10, n=100, p_connect=2/d, sparsity=3,
                                    noise_sd=1, noise_H=2, noise_I=2){
  ## Generate SCM
  B <- matrix(0, d, d)
  causalOrder <- sample(1:d)
  combinations <- combn(d, 2, simplify=FALSE)
  edges <- combinations[sample(c(TRUE, FALSE), length(combinations),
                               replace=TRUE, prob=c(p_connect, 1-p_connect))]
  if(length(edges) == 0){
    edges <- combinations[sample(1:length(combinations), 1)]
  }
  for(i in 1:length(edges)){
    e1 <- edges[[i]][1]
    e2 <- edges[[i]][2]
    if(which(causalOrder == e1) <= which(causalOrder == e2)){
      B[e2, e1] <- 1
    }
    else{
      B[e1, e2] <- 1
    }
  }
  Bstruct <- B
  B <- Bstruct*matrix(sample(c(-1,1),d^2, 0.5)*runif(d^2,0.5,1.5),
                      d, d)
  # Normalize the weights to avoid aggregation of variance
  B <- t(apply(B, 1, function(x) x/max(c(sum(x != 0), 1))))
  
  A <- matrix(0, d, m)
  for(i in 1:d){
    A[i,] <- sample(c(0, 1), prob=c(1-2/d, 2/d), m, replace=TRUE)
  }
  diag(A) <- 1

  beta_star <- matrix(0, d, 1)
  parents <- sample(1:d, sparsity, replace=FALSE)
  beta_star[parents] <- rep(1, sparsity)

  ## Generate data
  I <- matrix(rnorm(n*m, 0, noise_I), m, n)
  conf_struct <- matrix(rep(1,d), ncol=1)

  # Sample data
  H <- matrix(rnorm(n, 0, noise_H), 1, n)
  X <- matrix(NA, n, d)
  eps <- matrix(rnorm(n*(d+1), 0, noise_sd), d+1, n)
  X <- t(solve(diag(d)-B, eps[1:d,] + A %*% I + conf_struct %*% H))
  Y <- X %*% beta_star - 2*t(H) + eps[d+1,]
         

  ## Return results
  return(list(X=X,
              Y=Y,
              I=t(I),
              A=A,
              B=B,
              parents=parents,
              beta_star=beta_star))
}
