library(ggplot2)

# Load results
load("results/full_results.Rda")
     
dfres <- full_results$results
n_grid <- full_results$parameters$n_grid
dfres$n <- as.numeric(dfres$n)
dfres$n <- as.factor(dfres$n)


## Plotting
num_sims <- table(dfres$valid_ass)/(length(unique(dfres$method))*length(n_grid))
# Plot all simulations
p <- ggplot(dfres[dfres$valid_ass,], aes(x=n, y=loss, color=method)) + geom_boxplot()
p <- p + scale_y_continuous(limits = c(0, 2))
p <- p + theme(text=element_text(family="LM Roman 10", size=16))
p <- p + theme(legend.position="top",
               legend.title=element_blank(),
               legend.text=element_text(size=13))
p <- p + xlab("sample size") + ylab("RMSE")
ggsave("results/consistency_experiment_all.pdf",
       width=6, height=4, device=cairo_pdf)

# Plot all simulations - non-identifiable
p <- ggplot(dfres[!dfres$valid_ass,], aes(x=n, y=loss, color=method)) + geom_boxplot()
p <- p + theme(text=element_text(family="LM Roman 10", size=16))
p <- p + scale_y_continuous(limits = c(0, 2))
p <- p + theme(legend.position="top",
               legend.title=element_blank(),
               legend.text=element_text(size=13))
p <- p + xlab("sample size") + ylab("RMSE")
ggsave("results/consistency_experiment_all_nonidentifiable.pdf",
       width=6, height=4, device=cairo_pdf)

# Plot only simulations with estimated_sparsity=2
dfres_subset <- dfres[dfres$estimated_sparsity == 2,]
p <- ggplot(dfres_subset[dfres_subset$valid_ass,],
            aes(x=n, y=loss, color=method)) + geom_boxplot()
p <- p + theme(text=element_text(family="LM Roman 10", size=16))
p <- p + scale_y_continuous(limits = c(0, 2))
p <- p + theme(legend.position="top",
               legend.title=element_blank(),
               legend.text=element_text(size=13))
p <- p + xlab("sample size") + ylab("RMSE")
ggsave("results/consistency_experiment_correct_sparsity.pdf",
       width=6, height=4, device=cairo_pdf)


# Plot expected probability of getting estimating sparsity correct
dfres_sub <- dfres[dfres$method == "spaceIV" & dfres$valid_ass,]
estimated_sparsity <- vector("numeric", length(n_grid))
for(i in 1:length(n_grid)){
  estimated_sparsity[i] <- mean(dfres_sub$estimated_sparsity[dfres_sub$n == n_grid[i]]==2)
}
N <- sum(dfres_sub$n == n_grid[1])
df <- data.frame(n=n_grid,
                 estimated_sparsity=estimated_sparsity,
                 ubdd=qbinom(0.95, N, estimated_sparsity)/N,
                 lbdd=qbinom(0.05, N, estimated_sparsity)/N)
p <- ggplot(df, aes(x=n, y=estimated_sparsity)) + geom_point() + geom_line()
p <- p + geom_errorbar(aes(ymin=lbdd, ymax=ubdd))
p <- p + theme(text=element_text(family="LM Roman 10", size=16))
p <- p + xlab("sample size") + ylab("est. prob. sparsity correct")
ggsave("results/expected_fraction_correct_sparsity.pdf",
       width=6, height=4, device=cairo_pdf)


# Plot max sample size with different settings of the assumptions
assumptions <- dfres$valid_ass
assumptions[dfres$valid_ass] <- "A1 & A3"
assumptions[dfres$assA1 & !dfres$valid_ass] <- "A1"
assumptions[dfres$assA3 & !dfres$valid_ass] <- "A3"
assumptions[!dfres$assA1 & !dfres$assA3 & !dfres$valid_ass] <- "none"
assumptions <- as.factor(assumptions)
dfres$assumptions <- assumptions
dfres_sub <- dfres[dfres$n==1600,]

p <- ggplot(dfres_sub,
            aes(x=assumptions, y=loss, color=method)) + geom_boxplot()
p <- p + scale_y_continuous(limits = c(0, 2))
p <- p + theme(text=element_text(family="LM Roman 10", size=16))
p <- p + theme(legend.position="top",
               legend.title=element_blank(),
               legend.text=element_text(size=13))
p <- p + xlab("") + ylab("RMSE")
ggsave("results/mse_vs_assumptions.pdf",
       width=6, height=4, device=cairo_pdf)
