# Installation instructions with conda:
Unzip the files into a new directory (named viac in this example).
Execute the following:
```
conda env create -f path_to_viac_dir/viac/viac_env.yml
conda activate viac
pip install gymnasium==0.29.0 --no-dependencies
```
# Instructions to running the code
## VI-DDPG:
MTK experiments with double critics:
```
python /path_to_viac/viac/vi_ddpg_continuous_action.py --env-id=environment_name --total_timesteps=3000000 --vi_operator=mean_top_k --learning_starts=10000 --k=4 --n=128 --double_critics
```
I_N experiments with double critics:
```
python /path_to_viac/viac/vi_ddpg_continuous_action.py --env-id=environment_name --total_timesteps=3000000 --vi_operator=gaussian_search_vi --learning_starts=10000 --m=16 --n=16 --double_critics
```
Baseline DDPG with double critics:
```
python /path_to_viac/viac/vi_ddpg_continuous_action.py --env-id=environment_name --total_timesteps=3000000 --vi_operator=baseline --learning_starts=10000 --double_critics
```
Baseline DDPG:
```
python /path_to_viac/viac/vi_ddpg_continuous_action.py --env-id=environment_name --total_timesteps=3000000 --learning_starts=10000
```

## VI-TD3:
I_N experiments:
```
python /path_to_viac/viac/vi_td3_continuous_action.py --env-id=environment_name --total_timesteps=3000000 --vi_operator=gaussian_search_vi --learning_starts=10000 --m=16 --n=16
```
Baseline TD3:
```
python /path_to_viac/viac/vi_td3_continuous_action.py --env-id=environment_name --total_timesteps=3000000 --learning_starts=10000
```

## Additional baselines:
MPO:
```
python /path_to_viac/viac/mpo_continuous_action.py --env-id=environment_name --total_timesteps=3000000 --learning_starts=10000
```

PPO:
```
python /path_to_viac/viac/ppo_continuous_action.py --env-id=environment_name --total_timesteps=3000000
```

All experiments can be tracked in WANDB by adding 
```
--wandb_project_name=project_name --track
```