# Step 1: Find entities in question and answer
prompt_for_question_to_entities = """**Task Instruction:**

Identify and list all proper nouns (names of specific people, places, characters, titles, etc.) from the provided **Question** and **Answer**.

**Guidelines:**

1. **Analyze the Input:**
- Review both the question and answer carefully.
- Extract proper nouns that refer to specific entities.

2. **Output Format:**
Provide the results strictly following this JSON format:

{{
  "question": ["Proper nouns from the question"],
  "answer": ["Proper nouns from the answer"]
}}

**Example:**

Input:

Question: who does seth macfarlane play on american dad  
Answer: stan smith and roger  

Output:

{{
  "question": ["Seth MacFarlane", "American Dad"],
  "answer": ["Stan Smith", "Roger"]
}}

**Inputs:**
- **Question:**  
{question}

- **Answer:**  
{answer}

Now, extract proper nouns from the provided question-answer pair.
"""


prompt_rq_including_entity = """### Task Instruction:

You are given a reference question, an entity in the question, and a test question. Your task is to check if the test question is about the entity in the reference question.

### Guidelines:

1. **Read the reference question and the test question**

2. **Check if the test question is about the entity in the reference question**
- If the test question is about the entity in the reference question, output "Yes"
- If the test question is not about the entity in the reference question, output "No"

### Example:

**Inputs:**
- Reference Question: what building is on the cover of hotel california
- An entity in the reference question: Hotel California
- Test Question: What is the story behind the Hotel California?

**Output:**
Yes

**Inputs:**
- Reference Question: what building is on the cover of hotel california
- An entity in the reference question: Hotel California
- Test Question: Is Camarillo north or south California?

**Output:** 
No 

### Your task: 

*Inputs:*
- Reference Question: {reference_question}
- An entity in the reference question: {entity}
- Test Question: {test_question}

*Output:*
"""


prompt_rq_including_answer = """### Task Instruction:

You are given a question, an according answer, and an entity. Your task is to check if the question or the answer is about the entity.

### Guidelines:

1. **Read the question and the answer**

2. **Check if the question or the answer is about the entity**
- If the question or the answer is about the entity, output "Yes"
- If the question or the answer is not about the entity, output "No".

### Example:

**Inputs:**
- Question: What is the book store in Harry Potter?
- Answer: The book store in Harry Potter is Flourish and Blotts, a shop for books and school supplies located in Diagon Alley.
- An entity: Flourish and Blotts

**Output:**
Yes

**Inputs:**
- Question: Who is the greatest rock band of all time?
- Answer: According to various rankings and opinions, Queen is widely regarded as one of the greatest rock bands of all time.
- An entity: Freddy Mercury

**Output:** 
No 

### Your task: 

*Inputs:*
- Question: {question}
- Answer: {answer}
- An entity: {entity}

*Output:*
"""



# Step 2: Reasoning on web pages
prompt_for_webpage_reasonchain = """### Task Instruction:

You are tasked with reading and analyzing web pages based on the following inputs: **Search Query**, **Searched Web Pages**, and **Reference Entity**. Your objective is to provide sentences that directly answer the **Search Query**, using relevant information found in the **Searched Web Pages** and grounding the answer in the context of the **Reference Entity**.

### Guidelines:

1. **Analyze the Searched Web Pages:**
- Carefully review each searched web page.
- Identify the most relevant factual information to directly answer the **Search Query**.

2. **Formulate an Answer:**
- Summarize your analysis in one clear, accurate, and grammatically correct sentence that explicitly addresses the **Search Query**.
- The answer ranges from 1 to 3 sentences.
- Ensure that the answer clearly references the provided **Reference Entity**

3. **Output Format:**
- **If helpful information is found:** Present your answer in 1 to 3 sentences beginning with:
`**Final Information**`

- **If no helpful information is found:** Output the following:
`**Final Information** No helpful information found.`

### Inputs:
- **Search Query:**  
{search_query}

- **Searched Web Pages:**  
{document}

- **Reference Entity:**  
{reference_entity}

Analyze each web page and clearly answer the query "{search_query}" in 1 to 3 sentences.
"""


# Step 3: Find related queries
prompt_for_clue_selection = """### Task Instruction:

You are given an entity and a list of clues related to that entity. Your task is to select clues that are relevant and provide distinct, non-redundant information about the provided entity.

### Guidelines:

1. **Select Relevant Clues:**
- From the given clues, choose up to 5 that are directly relevant to the provided entity.
- If multiple clues contain overlapping or similar information, select only one: the most specific, detailed, or directly related clue.
- Prefer clues with direct references, detailed context, and clear factual statements.

2. **Output Format:** 
- Provide the indices of the selected clues (indices start from 0).
- Clearly explain your reasoning behind selecting each clue.
- The output format is as follows:
**Selected Clues:** [index of the selected clue 1, index of the selected clue 2, ...]

**Explanation:** {{explanation}}


### Inputs:
- **Entity:**  
{entity}

- **Input Clues:**  
{input_list}
"""

prompt_for_clue_summarization = """### Task Instruction:

You are given an entity and a list of clues about the entity. Your task is to summarize each clue into a concise clue about the entity, but remain the key information of the clue.

### Guidelines:

1. **Summarize Clues:**
- Summarize each clue into a concise clue.
- Remain the key information of the clue. 

### Inputs:
- **Entity:**  
{entity}

- **Input Clues:**  
{input_list}

### Output Format:
**Summarized Clues:** 
[
  "{{clue 1 summary}}",
  "{{clue 2 summary}}",
  ...
]
"""

# Step 4: Generate complex question
prompt_for_complex_question_generation = """### Task Instruction:

You are provided with an entity and a set of clues. Then,  generate a complex, implicit question that logically guides to the provided entity as the correct answer, without explicitly naming it or the related entities removed from the clues.

### Guidelines:

1. **Analyze the Clues:**
- Carefully examine each clue provided.
- Identify unique characteristics or context from these clues that indirectly lead to the given entity.

2. **Generate a Complex Question:**
- Formulate an insightful, implicit question.
- Your question should guide logically towards the entity, encouraging deduction.
- Avoid using pronouns or names in the clues that are highly related to the given entity.

### Example:

- **Entity:**  
Queen

- **Clues:**  
1. Known for energetic and theatrical live performances.
2. Freddie Mercury was famous for a wide vocal range.
3. Famous for blending rock with operatic and theatrical styles.
4. Produced the legendary album "A Night at the Opera."
5. Noted for the iconic anthem frequently performed at sports events.

- **Correct Output:**
**Complex Question:** Which celebrated rock band, recognized for energetic and theatrical live performances and a lead singer renowned for his exceptional vocal range, is famed for an innovative blend of operatic style and rock, creating a legendary album that includes a universally popular anthem commonly heard in sporting venues?
---

### Now Complete the Task:

- **Entity:**  
{entity}

- **Selected Clues:**  
{input_list}

### Output Format:
**Complex Question:** {{complex_question}}
"""

# prompt_for_complex_question_generation = """### Task Instruction:

# You are provided with an entity and a set of selected clues. Your objective is to generate a complex, implicit question that logically guides to the provided entity as the correct answer, without explicitly naming it or closely related entities found in the clues.

# ### Guidelines:

# 1. **Analyze the Selected Clues:**
# - Carefully examine each clue provided.
# - Identify unique characteristics or context from these clues that indirectly lead to the given entity.

# 2. **Generate a Complex Question:**
# - Formulate an insightful, implicit question.
# - Avoid explicitly mentioning the entity itself or closely related entities mentioned in the clues.
# - Do not include the content that is not in the clues.
# - Your question should guide logically towards the entity, encouraging deduction.

# ### Examples:

# - **Entity:**  
# Queen

# - **Selected Clues:**  
# 1. Known for energetic and theatrical live performances.
# 2. Freddie Mercury was famous for a wide vocal range.
# 3. Famous for blending rock with operatic and theatrical styles.
# 4. Produced the legendary album "A Night at the Opera."
# 5. Noted for the iconic anthem frequently performed at sports events.

# - **Correct Output:**
# **Complex Question:** Which celebrated rock band, recognized for dramatic live performances and a lead singer renowned for his exceptional vocal range, is famed for an innovative blend of operatic style and rock, creating a legendary album that includes a universally popular anthem commonly heard in sporting venues?

# Make sure that the question doesn't include content that is not in the clues. And also do not mention closely related entities found in the clues.

# ### Now Complete the Task:

# **Inputs:**
# - **Entity:**  
# {entity}

# - **Selected Clues:**  
# {input_list}

# **Output Format:**
# **Complex Question:** {{complex_question}}
# """


# Step 5: Integrate questions
prompt_for_question_integration = """**Task Instruction:**

You have two questions provided as inputs (**Q1** and **Q2**). Your task is to integrate the descriptive content of **Q2** (which answers the entity {entity}) into **Q1** by replacing only the specified entity ({entity}) in **Q1**.

**Guidelines:**

1. **Identify Entity:**
   - Clearly identify the entity ({entity}) within Q1 to replace.

2. **Integration Procedure:**
   - Replace only the entity ({entity}) from Q1 with the descriptive content of Q2.
   - The result must be one cohesive, grammatically correct, and logically coherent question.
   - Do not concatenate two separate questions. Instead, integrate smoothly.

3. **Output Format:**
   - Clearly present one single integrated question.

**Example:**

**Inputs:**
- **Q1:** Who is the lead vocal in Queen?
- **Q2:** Which celebrated rock band, recognized for dramatic live performances and a lead singer renowned for his exceptional vocal range, is famed for an innovative blend of operatic style and rock, creating a legendary album that includes a universally popular anthem commonly heard in sporting venues? (Answer: Queen)

- **Output:**
**Integrated Question:** Who is the lead vocal in the rock band, recognized for dramatic live performances and a lead singer renowned for his exceptional vocal range, is famed for an innovative blend of operatic style and rock, creating a legendary album that includes a universally popular anthem commonly heard in sporting venues?

---

**Now Complete the Task:**
**Inputs:**
- **Q1:** {question_1}
- **Q2:** {question_2} (Answer: {entity})

**Output Format:**
**Integrated Question:** {{integrated_question}}
"""

prompt_for_question_revision = """### Task instruction: The following question contains excessive detail and redundant information. Please rewrite the question using the steps below.

### Guidelines:

1. Identify key keywords.
- Clearly extract essential elements such as main characters, events, locations, and time periods.
2. Eliminate unnecessary redundancy and excessive detail.
- Remove repetitive phrases, overlapping terms, and overly detailed explanations.
3. Reconstruct a concise question clearly maintaining key keywords.
- Clearly present the core intent of the question in a succinct manner.
4. Final Review:
- Ensure that the revised question accurately reflects the original intent and preserves all necessary information.
5. Output Format:
**Revised Question:** {{revised question}}

### Example:

**Original Question:**
Who played the robber in the 1980s comedy film that features a fictional African kingdom known for its wealth and cultural richness, follows a young prince's humorous journey to the United States under a unique disguise, and highlights the comedic talents of its star, who portrayed multiple characters and was celebrated for his growing influence in Hollywood during that era?

**Revised Question:**
Who portrayed the robber in the 1980s comedy film featuring a prince from a wealthy fictional African kingdom journeying humorously to the United States, notable for its star actor playing multiple roles?

### Your Task: 

**Original Question:**
{question}
"""



################################################################################
# Prompts for generating model responses 
################################################################################


prompt_for_multiqa_search_o1 = """**Task Instruction:**

You are a reasoning assistant with the ability to perform web searches to help you answer the user's question accurately. You have special tools:

- To perform a search: write <|begin_search_queries|> your queries here <|end_search_queries|>.
Then, the system will search and analyze relevant web pages, then provide you with helpful information in the format <|begin_search_results|> ...search results... <|end_search_results|>.

You can repeat the search process multiple times if necessary. The maximum number of search attempts is limited to {MAX_SEARCH_LIMIT}.

Once you have all the information you need, continue your reasoning.

Example:
Question: "When was the first establishment that McDonaldization is named after, open in the country Horndean is located?"

Assistant thinking steps:
- I need to find out what McDonaldization is named after.
- Then, I need to determine which country Horndean is located in.
- Finally, I need to find out when the first McDonald’s opened in that country.

Assistant:
<|begin_search_queries|>What is McDonaldization named after?; Where is Horndean located?<|end_search_queries|>

(System returns processed information from relevant web pages)

Assistant thinks: McDonaldization is named after McDonald’s. Horndean is located in England. Now, I need to find out when the first McDonald’s opened in England.

Assistant:
<|begin_search_queries|>When did the first McDonald’s open in England?<|end_search_queries|>

(System returns processed information from relevant web pages)

Assistant continues reasoning with the new information...

Remember:
- Use <|begin_search_queries|> to request a web search and end with <|end_search_queries|>.
- If you have multiple queries that can be run in parallel, put them TOGETHER in the tokens.
- When done searching, continue your reasoning.
"""


prompt_for_openqa_task_instruction = """
Please answer the following question. You should provide your final answer in the format \\boxed{{YOUR_ANSWER}}.

Question:
{question}
"""


prompt_for_webpage_to_reasonchain_instruction = """**Task Instruction:**

You are tasked with reading and analyzing web pages based on the following inputs: **Previous Reasoning Steps**, **Current Search Query**, and **Searched Web Pages**. Your objective is to extract relevant and helpful information for **Current Search Query** from the **Searched Web Pages** and seamlessly integrate this information into the **Previous Reasoning Steps** to continue reasoning for the original question.

**Guidelines:**

1. **Analyze the Searched Web Pages:**
- Carefully review the content of each searched web page.
- Identify factual information that is relevant to the **Current Search Query** and can aid in the reasoning process for the original question.

2. **Extract Relevant Information:**
- Select the information from the Searched Web Pages that directly contributes to advancing the **Previous Reasoning Steps**.
- Ensure that the extracted information is accurate and relevant.

3. **Output Format:**
- **If the web pages provide helpful information for the current search query:** Present the information concisely beginning with `**Final Information**` as shown below.
**Final Information**

[Helpful information]

- **If the web pages do not provide any helpful information for current search query:** Output the following text.

**Final Information**

No helpful information found.

**Inputs:**
- **Previous Reasoning Steps:**  
{prev_reasoning}

- **Current Search Query:**  
{search_query}

- **Searched Web Pages:**  
{document}

Now you should analyze each web page and find helpful information based on the current search query "{search_query}" and previous reasoning steps.
"""

# Controlled workflow generation
prompt_for_workflow_instruction = """### Task Instruction:

Your goal is to create a structured search workflow from a provided complex question by clearly breaking down the reasoning into explicit, sequential steps.

### Input Structure & How to Use
- **Complex Question:**
A detailed, indirect question requiring inference about a specific entity or answer.

- **Answer:**
The known correct answer to the complex question.

- **Intermediate Question:**
A simplified version or intermediate step to identify a critical intermediate entity needed to solve the complex question.

- **Intermediate Answer:**
The known correct answer to the intermediate question, which you must use to guide subsequent reasoning steps.

- **Clues/Key Information:**
A bullet-point list containing hints and keywords used previously to infer the intermediate entity clearly.

### Step-by-Step Workflow Generation

- Clearly define the overall goal based on the complex question.
- Create clear, sequential steps for reasoning:
  - Step 1 should be designed explicitly to identify the intermediate entity from given clues.
  - Step 2 should confirm or find the final answer based on the intermediate entity.
- Suggest explicit search queries for each step (up to 5 queries per step recommended).
- Use the intermediate answer as confirmation or guidance for the second step.
- Don't include the intermediate answer, the answer, key entities in the clues in the queries
- Avoid redundant queries: Each query should uniquely contribute to the search goal without redundancy.

### Output Format

Strictly adhere to the following JSON format:
{{
  "goal": "{{goal}}",
  "steps": [
    {{
      "step": "{{explicitly describe this intermediate step clearly}}",
      "queries": ["query 1", "query 2", "..."],
      "intermediate_answer": "{{intermediate_answer}}"
    }},
    {{
      "step": "{{explicitly describe this final step clearly}}",
      "queries": ["final query referencing intermediate_answer"],
      "final_answer": "{{final_answer}}"
    }}  
  ]
}}  


### Example:

**Inputs:**

- **Complex Question:** 
Who is the lead vocal in the rock band recognized for dramatic live performances, a lead singer renowned for exceptional vocal range, an innovative blend of operatic style and rock, and a legendary album featuring an anthem frequently heard at sports events?

- **Answer:** 
Freddie Mercury

- **Intermediate Question:**
Which celebrated rock band, recognized for dramatic live performances and a lead singer renowned for his exceptional vocal range, is famed for an innovative blend of operatic style and rock, creating a legendary album that includes a universally popular anthem commonly heard in sporting venues?

- **Intermediate Answer:**
Queen

**Output:**

{{
  "goal": "Identify the lead vocalist of the described rock band",
  "steps": [
    {{
      "step": "Identify the rock band described explicitly in the intermediate question",
      "queries": [
        "Celebrated rock band with dramatic live performances and operatic style",
        "Rock band with a lead singer with exceptional vocal range",
        "Legendary rock album with a universal anthem heard in sporting venues"
      ],
      "intermediate_answer": "{{the rock band}}"
    }},
    {{
      "step": "Confirm the lead vocalist of identified rock band",
      "queries": ["Lead vocalist of {{the rock band}}"],
      "final_answer": "{{the lead vocalist}}"
    }}  
  ]
}}


### Now, generate a structured workflow based on the provided complex and intermediate questions.

**Inputs:**

- **Complex Question:**  
{question}

- **Answer:**  
{answer}

- **Intermediate Question:**
{intermediate_question}

- **Intermediate Answer:**  
{entities}

Now, generate a structured workflow based on the provided complex and intermediate questions. Make sure to use non-overlapping unique search queries for each step.
"""


prompt_for_sequential_workflow_instruction = """### Task Instruction:

Based on the question, existing workflow and model's actual outputs (search results and intermediate reasoning), carefully evaluate and update the current structured workflow to make it more efficient, clear, and robust.

### Guidlines
1. **Evaluate the current workflow**:
- The model's actual outputs are intermediate reasoning and search results generated based on the current workflow.
- Before moving to the next step, evaluate whether the current intermediate reasoning and search results have ambiguities or many possible answers to verify. 

2. **Update the workflow**:
- If the model's outputs have ambiguities or many possible answers to verify, you should add more steps to the workflow. 
- Please remain the steps done so far.
- Add new steps to the workflow to verify the ambiguities or many possible answers.

3. **Output Format**:
- Strictly adhere to the JSON format. 

### Example 

**Inputs:**

- **Question:**
Which celebrated rock band, recognized for dramatic live performances and a lead singer renowned for his exceptional vocal range, is famed for an innovative blend of operatic style and rock, creating a legendary album that includes a universally popular anthem commonly heard in sporting venues?

- **Current Workflow:**
{{
  "goal": "Identify the lead vocalist of the described rock band",
  "steps": [
    {{
      "step": "Identify the rock band described explicitly in the intermediate question",
      "queries": [
        "Celebrated rock band dramatic live performances operatic style",
        "Rock band lead singer exceptional vocal range",
        "Rock band blend of rock and operatic theatrical style",
        "Legendary rock album universal anthem heard sporting venues"
      ],
      "intermediate_answer": "Queen"
    }},
    {{
      "step": "Confirm the lead vocalist of identified rock band",
      "queries": ["Lead vocalist of {{the rock band}}"],
      "final_answer": "Freddie Mercury"
    }}  
  ]
}}

- **Model's Actual Outputs:**
Okay, let's start by identifying the rock band in question. 
...
<|begin_search_results|>
Celebrated rock band dramatic live performances operatic style: Queen, Pink Floyd, The Who.
Rock band lead singer exceptional vocal range: Axl Rose, Mariah Carey, Prince
Rock band blend of rock and operatic theatrical style: Freddy Mercury (Queen), Ronnie James Dio (DIO, Rainbow, Black Sabbath), Boz Burrell (King Crimson)
Legendary rock album universal anthem heard sporting venues: "Rock and Roll part2" Gary Glitter, "We are the champions" Queen, "We will rock you" Queen, "Are you ready for this" Jock Jams.
<|end_search_results|>


**Output:**
{{
  "goal": "Identify the lead vocalist of the described rock band",
  "steps": [
    {{
      "step": "Identify the rock band described explicitly in the intermediate question",
      "queries": [
        "Celebrated rock band dramatic live performances operatic style",
        "Rock band lead singer exceptional vocal range",
        "Rock band blend of rock and operatic theatrical style",
        "Legendary rock album universal anthem heard sporting venues"
      ],
      "intermediate_answer": "Queen, Pink Floyd, The Who"
    }},
    {{
      "step": "Confirm which of the narrowed candidates matches additional conditions",
      "queries": [
        "Queen's operatic operatic style and lead singer exceptional vocal range",
        "Pink Floyd's lead singer exceptional vocal range and operatic style",
        "The Who's lead singer exceptional vocal range and operatic style"
      ],
      "intermediate_answer": "Queen"
    }},
    {{  
      "step": "Identify the lead vocalist of Queen",
      "queries": [
        "Lead vocalist of Queen"
      ],
      "final_answer": "Freddie Mercury"
    }}
  ]
}}

### Now, evaluate and update the current workflow based on the provided question and model's actual outputs.

- **Question:**
{question}

- **Current Workflow:**
{workflow}

- **Model's Actual Outputs:**
{model_outputs}

**Output:**
"""

    
prompt_for_response_generatinon_given_workflow = """### Task Instruction:
You will be given a question and a structured workflow outlining logical steps and necessary queries to reach the final answer. Your task is to generate a detailed and step-by-step reasoning answer following the provided workflow.

### Guidelines for Reasoning Answer Generation:
- Try to solve the probelm, assuming that you don't know the workflow.
- Clearly follow each logical step outlined in the given workflow.
- For each step, explicitly perform the suggested queries from the workflow, using:
<|begin_search_queries|>
query 1;
query 2;
...
<|end_search_queries|>
- Clearly confirm findings from <|begin_search_results|>...<|end_search_results|> at each intermediate step and state a concise conclusion before moving to the next step.
- Use natural and conversational reasoning transitions (e.g., "First", "Wait", "Next", "Alternatively") to improve readability.
- Don't include answers in each step before performing queries in the step. 
- Clearly present the final answer at the end of the reasoning as follows:
**Final Answer:**
\\boxed{{YOUR_ANSWER}}

### Example 

**Inputs:** 
- Question: 
Who is the lead vocal in the rock band recognized for dramatic live performances, a lead singer renowned for exceptional vocal range, an innovative blend of operatic style and rock, and a legendary album featuring an anthem frequently heard at sports events?

- Workflow: 
{{
  "goal": "Identify the lead vocalist of the described rock band",
  "steps": [
    {{
      "step": "Identify the rock band using provided clues",
      "queries": [
        "Rock band known for dramatic live performances and operatic-rock fusion",
        "Rock band with lead vocalist known for exceptional vocal range",
        "Rock band anthem commonly played at sports events",
      ]
    }},
    {{
      "step": "Confirm the lead vocalist of the identified rock band",
      "queries": ["The lead vocalist of {{the rock band}}"]
    }}    
  ]
}}

**Output:** 
<think> 
Okay, let's analyze the clues step by step. The question mentions a rock band known for dramatic live performances, operatic-rock fusion, and a universally recognized sports anthem. Additionally, the band's lead vocalist is notable for an exceptional vocal range.

Initially, several bands might fit this description, so I should perform some searches to narrow this down:
</think>

<|begin_search_queries|>
Rock band known for dramatic live performances and operatic-rock fusion;
Rock band with lead vocalist known for exceptional vocal range;
Rock band anthem commonly played at sports events
<|end_search_queries|>

<|begin_search_results|>

... The described band is Queen. ...

<|end_search_results|>

Given these strong clues, it could directly point towards Queen, particularly due to their operatic style, famously exemplified in the legendary album "A Night at the Opera”. Indeed, Queen's anthems like "We Will Rock You" and "We Are the Champions" are frequently played at sporting events. Their vocalist, Freddie Mercury, is widely celebrated for his exceptional vocal range and theatrical stage presence.

To confirm this clearly, let's verify the lead vocalist of Queen explicitly:

<|begin_search_queries|>
The lead vocalist of Queen
<|end_search_queries|>

<|begin_search_results|>

... The lead vocalist of Queen is Freddie Mercury. ...

<|end_search_results|>

Given these confirmations, the band described by the clues is indeed Queen, and their iconic lead vocalist was Freddie Mercury.

**Final Answer:**
\\boxed{{Freddie Mercury}}

---

### Inputs:

- **Question:**  
{question}

- **Workflow:**  
{workflow}

Now, generate your detailed reasoning answer based on the provided question and workflow.
"""


prompt_for_response_generatinon = """### Task Instruction:
You will be given a question. Your task is to generate a detailed and step-by-step reasoning answer with parallel web search queries.

### Guidelines for Reasoning Answer Generation:
- For each step, explicitly perform the suggested queries, using:
<|begin_search_queries|>
query 1;
query 2;
...
<|end_search_queries|>
- When you have multiple queries that can be parallelized, put them together in one <|begin_search_queries|> and <|end_search_queries|> block separated by semicolons.
- The search results are followed by the search queries between <|begin_search_results|>...<|end_search_results|>. So, clearly confirm findings at each intermediate step and state a concise conclusion before moving to the next step.
- Use natural and conversational reasoning transitions (e.g., "First", "Wait", "Next", "Alternatively") to improve readability.
- Clearly present the final answer at the end of the reasoning as follows:
**Final Answer:**
\\boxed{{YOUR_ANSWER}}

### Example 

**Inputs:** 
- Question: 
Who is the lead vocal in the rock band recognized for dramatic live performances, a lead singer renowned for exceptional vocal range, an innovative blend of operatic style and rock, and a legendary album featuring an anthem frequently heard at sports events?

**Output:** 
<think> 
Okay, let's analyze the clues step by step. The question asks to find the lead vocalist of a rock band known for dramatic live performances and operatic-rock fusion, the lead vocalist's exceptional vocal range, and an universally recognized sports anthem. Let's start by searching for the rock band and then the lead vocalist.

Initially, several bands might fit this description, so I should perform some searches to narrow this down:
</think>

<|begin_search_queries|>
Rock band known for dramatic live performances and operatic-rock fusion;
Rock band with lead vocalist known for exceptional vocal range;
Rock band anthem commonly played at sports events
<|end_search_queries|>

<|begin_search_results|>

... The described band is Queen. ...

<|end_search_results|>

Given these strong clues, it could directly point towards Queen, particularly due to their operatic style, famously exemplified in the legendary album "A Night at the Opera”. Indeed, Queen's anthems like "We Will Rock You" and "We Are the Champions" are frequently played at sporting events. Their vocalist, Freddie Mercury, is widely celebrated for his exceptional vocal range and theatrical stage presence.

To confirm this clearly, let's verify the lead vocalist of Queen explicitly:

<|begin_search_queries|>
The lead vocalist of Queen
<|end_search_queries|>

<|begin_search_results|>

... The lead vocalist of Queen is Freddie Mercury. ...

<|end_search_results|>

Given these confirmations, the band described by the clues is indeed Queen, and their iconic lead vocalist was Freddie Mercury.

**Final Answer:**
\\boxed{{Freddie Mercury}}

---

### Inputs:

- **Question:**  
{question}


Now, generate your detailed reasoning answer based on the provided question.
"""


prompt_for_response_generatinon_w_search_limit = """### Task Instruction:
You will be given a question. Your task is to generate a detailed and step-by-step reasoning answer with parallel web search queries.

### Guidelines for Reasoning Answer Generation:
- For each step, explicitly perform the suggested queries, using:
<|begin_search_queries|>
query 1;
query 2;
...
<|end_search_queries|>
- When you have multiple queries that can be parallelized, put them together in one <|begin_search_queries|> and <|end_search_queries|> block separated by semicolons.
- The search results are followed by the search queries between <|begin_search_results|>...<|end_search_results|>. So, clearly confirm findings at each intermediate step and state a concise conclusion before moving to the next step.
- Use natural and conversational reasoning transitions (e.g., "First", "Wait", "Next", "Alternatively") to improve readability.
- The maximum number of total search queries is limited to {MAX_SEARCH_LIMIT}.
- Clearly present the final answer at the end of the reasoning as follows:
**Final Answer:**
\\boxed{{YOUR_ANSWER}}

### Example 

**Inputs:** 
- Question: 
Who is the lead vocal in the rock band recognized for dramatic live performances, a lead singer renowned for exceptional vocal range, an innovative blend of operatic style and rock, and a legendary album featuring an anthem frequently heard at sports events?

**Output:** 
<think> 
Okay, let's analyze the clues step by step. The question asks to find the lead vocalist of a rock band known for dramatic live performances and operatic-rock fusion, the lead vocalist's exceptional vocal range, and an universally recognized sports anthem. Let's start by searching for the rock band and then the lead vocalist.

Initially, several bands might fit this description, so I should perform some searches to narrow this down:
</think>

<|begin_search_queries|>
Rock band known for dramatic live performances and operatic-rock fusion;
Rock band with lead vocalist known for exceptional vocal range;
Rock band anthem commonly played at sports events
<|end_search_queries|>

<|begin_search_results|>

... The described band is Queen. ...

<|end_search_results|>

Given these strong clues, it could directly point towards Queen, particularly due to their operatic style, famously exemplified in the legendary album "A Night at the Opera”. Indeed, Queen's anthems like "We Will Rock You" and "We Are the Champions" are frequently played at sporting events. Their vocalist, Freddie Mercury, is widely celebrated for his exceptional vocal range and theatrical stage presence.

To confirm this clearly, let's verify the lead vocalist of Queen explicitly:

<|begin_search_queries|>
The lead vocalist of Queen
<|end_search_queries|>

<|begin_search_results|>

... The lead vocalist of Queen is Freddie Mercury. ...

<|end_search_results|>

Given these confirmations, the band described by the clues is indeed Queen, and their iconic lead vocalist was Freddie Mercury.

**Final Answer:**
\\boxed{{Freddie Mercury}}

---

### Inputs:

- **Question:**  
{question}


Now, generate your detailed reasoning answer based on the provided question.
"""


# prompt_for_response_generatinon = """### Task Instruction:

# You are a reasoning assistant with the ability to perform web searches to help you accurately answer the user's question. Follow the provided workflow carefully:

# - Clearly follow each logical step outlined in the given workflow.
# - Explicitly perform the suggested queries from the workflow, using:

# <|begin_search_queries|>
# query 1;
# query 2;
# ...
# <|end_search_queries|>

# The system will execute your queries and provide the resulting information formatted as:

# <|begin_search_results|>
# ...search results...
# <|end_search_results|>

# You may repeat the search process multiple times if necessary.

# Once you have all the required information from your searches, clearly continue your reasoning step-by-step.

# ### Guidelines:

# - Clearly describe your reasoning at each step.
# - Explicitly confirm intermediate findings after each search before moving to the next step. 
# - Use natural transitions ("First", "Next", "Then", "Alternatively", etc.) to guide the reasoning process.
# - Clearly state your final answer using the following format: 
# **Final Answer:**\n\\boxed{{YOUR_ANSWER}}


# ### Example 

# **Inputs:** 
# - Question: 
# Who is the lead vocal in the rock band recognized for dramatic live performances, a lead singer renowned for exceptional vocal range, an innovative blend of operatic style and rock, and a legendary album featuring an anthem frequently heard at sports events?

# - Workflow: 
# {{
#   "goal": "Identify the lead vocalist of the described rock band",
#   "steps": [
#     {{
#       "step": "Identify the rock band using provided clues",
#       "queries": [
#         "Rock band known for dramatic live performances and operatic-rock fusion",
#         "Rock band with lead vocalist known for exceptional vocal range",
#         "Rock band anthem commonly played at sports events",
#       ]
#     }},
#     {{
#       "step": "Confirm the lead vocalist of the identified rock band",
#       "queries": ["The lead vocalist of {{the rock band}}"]
#     }}    
#   ]
# }}

# **Output:** 
# <think> 
# Okay, let's analyze the clues step by step. The question mentions a rock band known for dramatic live performances, operatic-rock fusion, and a universally recognized sports anthem. Additionally, the band's lead vocalist is notable for an exceptional vocal range.

# Initially, several bands might fit this description, so I should perform some searches to narrow this down:
# </think>

# <|begin_search_queries|>
# Rock band known for dramatic live performances and operatic-rock fusion;
# Rock band with lead vocalist known for exceptional vocal range;
# Rock band anthem commonly played at sports events
# <|end_search_queries|>

# <|begin_search_results|>

# ... The described band is Queen. ...

# <|end_search_results|>

# <think>
# Given these strong clues, it could directly point towards Queen, particularly due to their operatic style, famously exemplified in the legendary album "A Night at the Opera”. Indeed, Queen's anthems like "We Will Rock You" and "We Are the Champions" are frequently played at sporting events. Their vocalist, Freddie Mercury, is widely celebrated for his exceptional vocal range and theatrical stage presence.

# To confirm this clearly, let's verify the lead vocalist of Queen explicitly:
# </think>

# <|begin_search_queries|>
# The lead vocalist of Queen
# <|end_search_queries|>

# <|begin_search_results|>

# ... The lead vocalist of Queen is Freddie Mercury. ...

# <|end_search_results|>

# <think>
# Given these confirmations, the band described by the clues is indeed Queen, and their iconic lead vocalist was Freddie Mercury.
# </think>

# **Final Answer:**
# \\boxed{{Freddie Mercury}}

# ---
# ### Now, generate your detailed reasoning answer based on the provided question and workflow.

# **Inputs:**

# - Question:  
# {question}

# - Workflow:  
# {workflow}

# **Output:**
# """