# Step 1: Find entities in question and answer
prompt_for_question_to_entities = """**Task Instruction:**

Identify and list all proper nouns (names of specific people, places, characters, titles, etc.) from the provided **Question** and **Answer**.

**Guidelines:**

1. **Analyze the Input:**
- Review both the question and answer carefully.
- Extract proper nouns that refer to specific entities.

2. **Output Format:**
Provide the results strictly following this JSON format:

{{
  "question": ["Proper nouns from the question"],
  "answer": ["Proper nouns from the answer"]
}}

**Example:**

Input:

Question: who does seth macfarlane play on american dad  
Answer: stan smith and roger  

Output:

{{
  "question": ["Seth MacFarlane", "American Dad"],
  "answer": ["Stan Smith", "Roger"]
}}

**Inputs:**
- **Question:**  
{question}

- **Answer:**  
{answer}

Now, extract proper nouns from the provided question-answer pair.
"""


# Step 2: Reasoning on web pages
prompt_for_webpage_reasonchain = """**Task Instruction:**

You are tasked with reading and analyzing web pages based on the following inputs: **Search Query** and **Searched Web Pages**. Your objective is to provide a concise sentence that directly answers the **Search Query**, using relevant information found in the **Searched Web Pages**.

**Guidelines:**

1. **Analyze the Searched Web Pages:**
- Carefully review each searched web page.
- Identify the most relevant factual information to directly answer the **Search Query**.

2. **Formulate a Concise Answer:**
- Summarize your analysis in one clear, accurate, and grammatically correct sentence that explicitly addresses the **Search Query**.

3. **Output Format:**
- **If helpful information is found:** Present your answer in a single concise sentence beginning with:
`**Final Information**`

- **If no helpful information is found:** Output the following:
`**Final Information** No helpful information found.`

**Inputs:**
- **Search Query:**  
{search_query}

- **Searched Web Pages:**  
{document}

Analyze each web page and clearly answer the query "{search_query}" in a single concise sentence.
"""

# Step 3: Find related queries
prompt_for_clue_selection = """**Task Instruction:**

You are given an entity, a set of input clues, and a list of restricted entities. Your task is to select clues that are most relevant to the provided entity.

**Guidelines:**

1. **Remove Explicitly Mentioned Entities:**
- Remove any clues explicitly mentioning entities listed in the restricted entities.

2. **Select Relevant Clues:**
- From the remaining clues, select between 3 to 5 clues that:
  - Are most relevant to clearly indicating the provided entity.
  - Provide diverse contexts.

**Inputs:**
- **Entity:**  
{entity}

- **Input Clues:**  
{input_list}

- **Restricted Entities:**  
{r_entities}

**Output Format:**
[
  {{clue 1}},
  {{clue 2}},
  ...
]
"""

# Step 4: Generate complex question
prompt_for_complex_question_generation = """**Task Instruction:**

You are provided with an entity and a set of selected clues. Your objective is to generate a complex, implicit question that logically guides to the provided entity as the correct answer, without explicitly naming it or closely related entities found in the clues.

**Guidelines:**

1. **Analyze the Selected Clues:**
- Carefully examine each clue provided.
- Identify unique characteristics or context from these clues that indirectly lead to the given entity.

2. **Generate a Complex Question:**
- Formulate an insightful, implicit question.
- Avoid explicitly mentioning the entity itself or closely related entities mentioned in the clues.
- Your question should guide logically towards the entity, encouraging deduction.

**Example:**

- **Entity:**  
Queen

- **Selected Clues:**  
1. Known for energetic and theatrical live performances.
2. Freddie Mercury was famous for a wide vocal range.
3. Famous for blending rock with operatic and theatrical styles.
4. Produced the legendary album "A Night at the Opera."
5. Noted for the iconic anthem frequently performed at sports events.

- **Correct Output:**
**Complex Question:** Which celebrated rock band, recognized for dramatic live performances and a lead singer renowned for his exceptional vocal range, is famed for an innovative blend of operatic style and rock, creating a legendary album that includes a universally popular anthem commonly heard in sporting venues?

---

**Now Complete the Task:**

**Inputs:**
- **Entity:**  
{entity}

- **Selected Clues:**  
{input_list}

**Output Format:**
**Complex Question:** {{complex_question}}
"""

# Step 5: Integrate questions
prompt_for_question_integration = """**Task Instruction:**

You have two questions provided as inputs (**Q1** and **Q2**). Your objective is to integrate **Q2** into **Q1** by replacing only the specified entity (**{entity}**) from **Q1** with the descriptive content of **Q2**.

**Guidelines:**

1. **Identify Entity for Replacement:**
   - Clearly identify the entity (**{entity}**) in **Q1**.

2. **Integration Procedure:**
   - Replace **only** the entity (**{entity}**) in **Q1** with the descriptive content provided by **Q2**.
   - Maintain grammatical correctness, clarity, and coherence in the integrated question.

3. **Output Format:**
   - Present a single integrated question clearly.

**Example:**

**Inputs:**
- **Q1:** Who is the lead vocal in Queen?
- **Q2:** Which celebrated rock band, recognized for dramatic live performances and a lead singer renowned for his exceptional vocal range, is famed for an innovative blend of operatic style and rock, creating a legendary album that includes a universally popular anthem commonly heard in sporting venues? (Answer: Queen)

- **Output:**
**Integrated Question:** Who is the lead vocal in the rock band, recognized for dramatic live performances and a lead singer renowned for his exceptional vocal range, is famed for an innovative blend of operatic style and rock, creating a legendary album that includes a universally popular anthem commonly heard in sporting venues?

---

**Now Complete the Task:**
**Inputs:**
- **Q1:** {question_1}
- **Q2:** {question_2} (Answer: {entity})

**Output Format:**
**Integrated Question:** {{integrated_question}}
"""


################################################################################
# Prompts for generating model responses 
################################################################################

prompt_for_multiqa_search_o1 = """You are a reasoning assistant with the ability to perform web searches to help you answer the user's question accurately. You have special tools:

- To perform a search: write <|begin_search_query|> your query here <|end_search_query|>.
Then, the system will search and analyze relevant web pages, then provide you with helpful information in the format <|begin_search_result|> ...search results... <|end_search_result|>.

You can repeat the search process multiple times if necessary. The maximum number of search attempts is limited to {MAX_SEARCH_LIMIT}.

Once you have all the information you need, continue your reasoning.

Example:
Question: "Alice David is the voice of Lara Croft in a video game developed by which company?"
Assistant thinking steps:
- I need to find out who voices Lara Croft in the video game.
- Then, I need to determine which company developed that video game.

Assistant:
<|begin_search_query|>Alice David Lara Croft voice<|end_search_query|>

(System returns processed information from relevant web pages)

Assistant thinks: The search results indicate that Alice David is the voice of Lara Croft in a specific video game. Now, I need to find out which company developed that game.

Assistant:
<|begin_search_query|>video game developed by Alice David Lara Croft<|end_search_query|>

(System returns processed information from relevant web pages)

Assistant continues reasoning with the new information...

Remember:
- Use <|begin_search_query|> to request a web search and end with <|end_search_query|>.
- When done searching, continue your reasoning.
"""

prompt_for_multiqa_parallel_search_wo_limit = """**Task Instruction:**

You are a reasoning assistant with the ability to perform web searches to help you answer the user's question accurately. You have special tools:

- To perform a search: write <|begin_search_queries|> your queries here <|end_search_queries|>.
Then, the system will search and analyze relevant web pages, then provide you with helpful information in the format <|begin_search_results|> ...search results... <|end_search_results|>.

You can repeat the search process multiple times if necessary. 

Once you have all the information you need, continue your reasoning.

Example:
Question: "When was the first establishment that McDonaldization is named after, open in the country Horndean is located?"

Assistant thinking steps:
- I need to find out what McDonaldization is named after.
- Then, I need to determine which country Horndean is located in.
- Finally, I need to find out when the first McDonald’s opened in that country.

Assistant:
<|begin_search_queries|>
What is McDonaldization named after?;
Where is Horndean located?
<|end_search_queries|>

(System returns processed information from relevant web pages)

Assistant thinks: McDonaldization is named after McDonald’s. Horndean is located in England. Now, I need to find out when the first McDonald’s opened in England.

Assistant:
<|begin_search_queries|>When did the first McDonald’s open in England?<|end_search_queries|>

(System returns processed information from relevant web pages)

Assistant continues reasoning with the new information...

Remember:
- Use <|begin_search_queries|> to request a web search and end with <|end_search_queries|>.
- If you have multiple queries that can be run in parallel, put them TOGETHER in the tokens.
- When done searching, continue your reasoning.
"""

prompt_for_multiqa_parallel_search_w_search_limit = """**Task Instruction:**

You are a reasoning assistant with the ability to perform web searches to help you answer the user's question accurately. You have special tools:

- To perform a search: write <|begin_search_queries|> your queries here <|end_search_queries|>. 
Then, the system will search and analyze relevant web pages, then provide you with helpful information in the format <|begin_search_results|> ...search results... <|end_search_results|>.

You can repeat the search process multiple times if necessary. 

Once you have all the information you need, continue your reasoning. 

Example:
Question: "When was the first establishment that McDonaldization is named after, open in the country Horndean is located?"

Assistant thinking steps:
- I need to find out what McDonaldization is named after.
- Then, I need to determine which country Horndean is located in.
- Finally, I need to find out when the first McDonald’s opened in that country.

Assistant:
<|begin_search_queries|>What is McDonaldization named after?; Where is Horndean located?<|end_search_queries|>

(System returns processed information from relevant web pages)

Assistant thinks: McDonaldization is named after McDonald’s. Horndean is located in England. Now, I need to find out when the first McDonald’s opened in England.

Assistant:
<|begin_search_queries|>When did the first McDonald’s open in England?<|end_search_queries|>

(System returns processed information from relevant web pages)

Assistant continues reasoning with the new information...

Remember:
- Use <|begin_search_queries|> to request a web search and end with <|end_search_queries|>.
- If you have multiple queries that can be run in parallel, put them TOGETHER in the tokens.
- When done searching, continue your reasoning. 
"""

prompt_for_multiqa_parallel_search_w_turn_limit = """**Task Instruction:**

You are a reasoning assistant with the ability to perform web searches to help you answer the user's question accurately. You have special tools:

- To perform a search: write <|begin_search_queries|> your queries here <|end_search_queries|>.
Then, the system will search and analyze relevant web pages, then provide you with helpful information in the format <|begin_search_results|> ...search results... <|end_search_results|>.

You can repeat the search process multiple times if necessary. The maximum number of the search process is limited to {MAX_SEARCH_TURN}.

Once you have all the information you need, continue your reasoning. 

Example:
Question: "When was the first establishment that McDonaldization is named after, open in the country Horndean is located?"

Assistant thinking steps:
- I need to find out what McDonaldization is named after.
- Then, I need to determine which country Horndean is located in.
- Finally, I need to find out when the first McDonald's opened in that country.

Assistant:
<|begin_search_queries|>What is McDonaldization named after?; Where is Horndean located?<|end_search_queries|>

(System returns processed information from relevant web pages)

Assistant thinks: McDonaldization is named after McDonald's. Horndean is located in England. Now, I need to find out when the first McDonald's opened in England.

Assistant:
<|begin_search_queries|>When did the first McDonald's open in England?<|end_search_queries|>

(System returns processed information from relevant web pages)

Assistant continues reasoning with the new information...

Remember:
- Use <|begin_search_queries|> to request a web search and end with <|end_search_queries|>.
- If you have multiple queries that can be run in parallel, put them TOGETHER in the tokens.
- When done searching, continue your reasoning. 
- The maximum number of the search process is limited to {MAX_SEARCH_TURN}.
"""


prompt_for_openqa_task_instruction = """
Please answer the following question. You should provide your final answer in the format \\boxed{{YOUR_ANSWER}}.

Question:
{question}
"""

prompt_for_multiqa_parallel_search = """**Task Instruction:**

You are a reasoning assistant with the ability to perform web searches to help you answer the user's question accurately. You have special tools:

- To perform a search: write <|begin_search_queries|> your queries here <|end_search_queries|>.
Then, the system will search and analyze relevant web pages, then provide you with helpful information in the format <|begin_search_results|> ...search results... <|end_search_results|>.

You can repeat the search process multiple times if necessary. The maximum number of search attempts is limited to {MAX_SEARCH_LIMIT}.

Once you have all the information you need, continue your reasoning.

Example:
Question: "When was the first establishment that McDonaldization is named after, open in the country Horndean is located?"

Assistant thinking steps:
- I need to find out what McDonaldization is named after.
- Then, I need to determine which country Horndean is located in.
- Finally, I need to find out when the first McDonald’s opened in that country.

Assistant:
<|begin_search_queries|>
What is McDonaldization named after?;
Where is Horndean located?
<|end_search_queries|>

(System returns processed information from relevant web pages)

Assistant thinks: McDonaldization is named after McDonald’s. Horndean is located in England. Now, I need to find out when the first McDonald’s opened in England.

Assistant:
<|begin_search_queries|>When did the first McDonald’s open in England?<|end_search_queries|>

(System returns processed information from relevant web pages)

Assistant continues reasoning with the new information...

Remember:
- Use <|begin_search_queries|> to request a web search and end with <|end_search_queries|>.
- If you have multiple queries that can be run in parallel, put them TOGETHER in the tokens.
- When done searching, continue your reasoning.
"""


prompt_for_openqa_task_instruction = """
Please answer the following question. You should provide your final answer in the format \\boxed{{YOUR_ANSWER}}.

Question:
{question}
"""

prompt_for_summary_instruction = """
Please summary the information of the following question. You should provide your final answer in the format \nSummary: {{summary}}.

Question:
{question}
"""


prompt_for_webpage_to_reasonchain_instruction = """**Task Instruction:**

You are tasked with reading and analyzing web pages based on the following inputs: **Previous Reasoning Steps**, **Current Search Query**, and **Searched Web Pages**. Your objective is to extract relevant and helpful information for **Current Search Query** from the **Searched Web Pages** and seamlessly integrate this information into the **Previous Reasoning Steps** to continue reasoning for the original question.

**Guidelines:**

1. **Analyze the Searched Web Pages:**
- Carefully review the content of each searched web page.
- Identify factual information that is relevant to the **Current Search Query** and can aid in the reasoning process for the original question.

2. **Extract Relevant Information:**
- Select the information from the Searched Web Pages that directly contributes to advancing the **Previous Reasoning Steps**.
- Ensure that the extracted information is accurate and relevant.

3. **Output Format:**
- **If the web pages provide helpful information for current search query:** Present the information beginning with `**Final Information**` as shown below.
**Final Information**

[Helpful information]

- **If the web pages do not provide any helpful information for current search query:** Output the following text.

**Final Information**

No helpful information found.

**Inputs:**
- **Previous Reasoning Steps:**  
{prev_reasoning}

- **Current Search Query:**  
{search_query}

- **Searched Web Pages:**  
{document}

Now you should analyze each web page and find helpful information based on the current search query "{search_query}" and previous reasoning steps.
"""


# prompt_for_webpage_to_reasonchain_instruction = """**Task Instruction:**

# You are tasked with reading and analyzing web pages based on the following inputs: **Previous Reasoning Steps**, **Current Search Query**, and **Searched Web Pages**. Your objective is to extract relevant and matching information for **Current Search Query** from the **Searched Web Pages** and seamlessly integrate this information into the **Previous Reasoning Steps** to continue reasoning for the original question.

# **Guidelines:**

# 1. **Analyze the Searched Web Pages:**
# - Carefully review the content of each searched web page.
# - Identify factual information that is relevant to the **Current Search Query** and can aid in the reasoning process for the original question.

# 2. **Extract Relevant Information:**
# - Select the information from the Searched Web Pages that directly contributes to advancing the **Previous Reasoning Steps**.
# - Ensure that the extracted information is accurate, relevant, and matches the **Current Search Query**.

# 3. **Output Format:**
# - **If the web pages provide matching information for current search query:** Present the information briefly beginning with `**Final Information**` as shown below.
# **Final Information**

# [Matching information]

# - **If the web pages do not provide any matching information for current search query:** Output the following text.

# **Final Information**

# No helpful information found.

# **Inputs:**
# - **Previous Reasoning Steps:**  
# {prev_reasoning}

# - **Current Search Query:**  
# {search_query}

# - **Searched Web Pages:**  
# {document}

# Now you should analyze each web page and find matching information based on the current search query "{search_query}" and previous reasoning steps.
# """





# Controlled workflow generation
prompt_for_workflow_instruction = """### Task Instruction:

Your goal is to create a structured search workflow from a provided complex question by clearly breaking down the reasoning into explicit, sequential steps.

### Input Structure & How to Use
- **Complex Question:**
A detailed, indirect question requiring inference about a specific entity or answer.

- **Answer:**
The known correct answer to the complex question.

- **Intermediate Question:**
A simplified version or intermediate step to identify a critical intermediate entity needed to solve the complex question.

- **Intermediate Answer:**
The known correct answer to the intermediate question, which you must use to guide subsequent reasoning steps.

- **Clues/Key Information:**
A bullet-point list containing hints and keywords used previously to infer the intermediate entity clearly.

### Step-by-Step Workflow Generation

- Clearly define the overall goal based on the complex question.
- Create clear, sequential steps for reasoning:
  - Step 1 should be designed explicitly to identify the intermediate entity from given clues.
  - Step 2 should confirm or find the final answer based on the intermediate entity.
- Suggest explicit search queries for each step (up to 5 queries per step recommended).
- Use the intermediate answer as confirmation or guidance for the second step.
- Don't include the intermediate answer, the answer, key entities in the clues in the queries
- Avoid redundant queries: Each query should uniquely contribute to the search goal without redundancy.

### Output Format

Strictly adhere to the following JSON format:
{{
  "goal": "{{goal}}",
  "steps": [
    {{
      "step": "{{explicitly describe this intermediate step clearly}}",
      "queries": ["query 1", "query 2", "..."],
      "intermediate_answer": "{{intermediate_answer}}"
    }},
    {{
      "step": "{{explicitly describe this final step clearly}}",
      "queries": ["final query referencing intermediate_answer"],
      "final_answer": "{{final_answer}}"
    }}  
  ]
}}  


### Example:

**Inputs:**

- **Complex Question:** 
Who is the lead vocal in the rock band recognized for dramatic live performances, a lead singer renowned for exceptional vocal range, an innovative blend of operatic style and rock, and a legendary album featuring an anthem frequently heard at sports events?

- **Answer:** 
Freddie Mercury

- **Intermediate Question:**
Which celebrated rock band, recognized for dramatic live performances and a lead singer renowned for his exceptional vocal range, is famed for an innovative blend of operatic style and rock, creating a legendary album that includes a universally popular anthem commonly heard in sporting venues?

- **Intermediate Answer:**
Queen

**Output:**

{{
  "goal": "Identify the lead vocalist of the described rock band",
  "steps": [
    {{
      "step": "Identify the rock band described explicitly in the intermediate question",
      "queries": [
        "Celebrated rock band dramatic live performances operatic style",
        "Rock band lead singer exceptional vocal range",
        "Rock band blend of rock and operatic theatrical style",
        "Legendary rock album universal anthem heard sporting venues"
      ],
      "intermediate_answer": "Queen"
    }},
    {{
      "step": "Confirm the lead vocalist of identified rock band",
      "queries": ["Lead vocalist of {{the rock band}}"],
      "final_answer": "Freddie Mercury"
    }}  
  ]
}}


### Now, generate a structured workflow based on the provided complex and intermediate questions.

**Inputs:**

- **Complex Question:**  
{question}

- **Answer:**  
{answer}

- **Intermediate Question:**
{intermediate_question}

- **Intermediate Answer:**  
{entities}

Now, generate a structured workflow based on the provided complex and intermediate questions.
"""

# workflow prompt based on knowledge state -> doesn't work well
# prompt_for_workflow_instruction_updated = """### Task Instruction:

# Given a question-answer pair, generate a structured workflow outlining clear logical steps and corresponding sets of queries required to accurately answer the question, considering your current knowledge state.

# ### Guidelines:
# - Clearly define a concise goal based on the provided question.
# - Each step should represent a distinct logical reasoning stage.
# - Each step's queries should be executable simultaneously, containing all necessary searches to proceed without additional intermediate queries.
# - Ensure search queries for each step do not significantly overlap.
# - Adapt the workflow according to your level of knowledge:
#   - No knowledge: broad queries to identify the context first.
#   - Partial knowledge: targeted queries for validation and retrieval.
#   - Complete knowledge: concise validation queries only.


# ### Output Format:

# Strictly adhere to the following JSON format:

# {{
#   "goal": "Concise statement of what the final answer aims to achieve",
#   "steps": [
#     {{
#       "step": "Brief description of reasoning step 1",
#       "queries": ["Relevant query 1", ... ]
#     }},
#     {{
#       "step": "Brief description of reasoning step 2",
#       "queries": ["Relevant query 1", ... ]
#     }}
#   ]
# }}  

# ### Example:

# Input:
# Question: 
# Who is the lead vocal in the rock band recognized for dramatic live performances, a lead singer renowned for exceptional vocal range, an innovative blend of operatic style and rock, and a legendary album featuring an anthem frequently heard at sports events?

# Output:
# - If you don't know the band:
# {{
#   "goal": "Identify the lead vocalist of the described rock band",
#   "steps": [
#     {{
#       "step": "Identify the rock band using provided clues",
#       "queries": [
#         "Rock band known for dramatic live performances and operatic-rock fusion",
#         "Rock band with lead vocalist known for exceptional vocal range",
#         "Rock band anthem commonly played at sports events",
#       ]
#     }},
#     {{
#       "step": "Confirm the lead vocalist of the identified rock band",
#       "queries": ["The lead vocalist of {{the rock band}}"]
#     }}    
#   ]
# }}
# - If you know the band but not the vocalist:
# {{
#   "goal": "Identify the lead vocalist of Queen, while briefly validating that Queen fits the given clues",
#   "steps": [
#     {{
#       "step": "Verify Queen matches the clues and retrieve the lead vocalist",
#       "queries": [
#         "Queen dramatic live performances operatic rock blend sports anthem",
#         "lead vocalist of Queen"
#       ]
#     }}
#   ]
# }}
# - If you know Freddie Mercury is the lead vocalist of Queen:
# {{
#   "goal": "Confirm and state that Freddie Mercury is the lead vocalist of Queen",
#   "steps": [
#     {{
#       "step": "Confirm Queen matches the provided description and validate the lead vocalist",
#       "queries": ["Queen dramatic live performances operatic rock blend sports anthem", "Freddie Mercury lead vocalist Queen"]
#     }}
#   ]
# }}
# ### Inputs:

# - Question:  
# {question}

# Now, generate a structured workflow based on the provided question-answer pair.
# """

    
prompt_for_response_generatinon = """### Task Instruction:
You will be given a question and a structured workflow outlining logical steps and necessary queries to reach the final answer. Your task is to generate a detailed and step-by-step reasoning answer following the provided workflow.

### Guidelines for Reasoning Answer Generation:
- Try to solve the probelm, assuming that you don't know the workflow.
- Clearly follow each logical step outlined in the given workflow.
- For each step, explicitly perform the suggested queries from the workflow, using:
<|begin_search_queries|>
query 1;
query 2;
...
<|end_search_queries|>
- Clearly confirm findings from <|begin_search_results|>...<|end_search_results|> at each intermediate step and state a concise conclusion before moving to the next step.
- Use natural and conversational reasoning transitions (e.g., "First", "Wait", "Next", "Alternatively") to improve readability.
- Don't include answers in each step before performing queries in the step. 
- Clearly present the final answer at the end of the reasoning as follows:
**Final Answer:**
\\boxed{{YOUR_ANSWER}}

### Example 

**Inputs:** 
- Question: 
Who is the lead vocal in the rock band recognized for dramatic live performances, a lead singer renowned for exceptional vocal range, an innovative blend of operatic style and rock, and a legendary album featuring an anthem frequently heard at sports events?

- Workflow: 
{{
  "goal": "Identify the lead vocalist of the described rock band",
  "steps": [
    {{
      "step": "Identify the rock band using provided clues",
      "queries": [
        "Rock band known for dramatic live performances and operatic-rock fusion",
        "Rock band with lead vocalist known for exceptional vocal range",
        "Rock band anthem commonly played at sports events",
      ]
    }},
    {{
      "step": "Confirm the lead vocalist of the identified rock band",
      "queries": ["The lead vocalist of {{the rock band}}"]
    }}    
  ]
}}

**Output:** 
<think> 
Okay, let's analyze the clues step by step. The question mentions a rock band known for dramatic live performances, operatic-rock fusion, and a universally recognized sports anthem. Additionally, the band's lead vocalist is notable for an exceptional vocal range.

Initially, several bands might fit this description, so I should perform some searches to narrow this down:
</think>

<|begin_search_queries|>
Rock band known for dramatic live performances and operatic-rock fusion;
Rock band with lead vocalist known for exceptional vocal range;
Rock band anthem commonly played at sports events
<|end_search_queries|>

<|begin_search_results|>

... The described band is Queen. ...

<|end_search_results|>

Given these strong clues, it could directly point towards Queen, particularly due to their operatic style, famously exemplified in the legendary album "A Night at the Opera”. Indeed, Queen's anthems like "We Will Rock You" and "We Are the Champions" are frequently played at sporting events. Their vocalist, Freddie Mercury, is widely celebrated for his exceptional vocal range and theatrical stage presence.

To confirm this clearly, let's verify the lead vocalist of Queen explicitly:

<|begin_search_queries|>
The lead vocalist of Queen
<|end_search_queries|>

<|begin_search_results|>

... The lead vocalist of Queen is Freddie Mercury. ...

<|end_search_results|>

Given these confirmations, the band described by the clues is indeed Queen, and their iconic lead vocalist was Freddie Mercury.

**Final Answer:**
\\boxed{{Freddie Mercury}}

---

### Inputs:

- **Question:**  
{question}

- **Workflow:**  
{workflow}

Now, generate your detailed reasoning answer based on the provided question and workflow.
"""

# prompt_for_response_generatinon = """### Task Instruction:

# You are a reasoning assistant with the ability to perform web searches to help you accurately answer the user's question. Follow the provided workflow carefully:

# - Clearly follow each logical step outlined in the given workflow.
# - Explicitly perform the suggested queries from the workflow, using:

# <|begin_search_queries|>
# query 1;
# query 2;
# ...
# <|end_search_queries|>

# The system will execute your queries and provide the resulting information formatted as:

# <|begin_search_results|>
# ...search results...
# <|end_search_results|>

# You may repeat the search process multiple times if necessary.

# Once you have all the required information from your searches, clearly continue your reasoning step-by-step.

# ### Guidelines:

# - Clearly describe your reasoning at each step.
# - Explicitly confirm intermediate findings after each search before moving to the next step. 
# - Use natural transitions ("First", "Next", "Then", "Alternatively", etc.) to guide the reasoning process.
# - Clearly state your final answer using the following format: 
# **Final Answer:**\n\\boxed{{YOUR_ANSWER}}


# ### Example 

# **Inputs:** 
# - Question: 
# Who is the lead vocal in the rock band recognized for dramatic live performances, a lead singer renowned for exceptional vocal range, an innovative blend of operatic style and rock, and a legendary album featuring an anthem frequently heard at sports events?

# - Workflow: 
# {{
#   "goal": "Identify the lead vocalist of the described rock band",
#   "steps": [
#     {{
#       "step": "Identify the rock band using provided clues",
#       "queries": [
#         "Rock band known for dramatic live performances and operatic-rock fusion",
#         "Rock band with lead vocalist known for exceptional vocal range",
#         "Rock band anthem commonly played at sports events",
#       ]
#     }},
#     {{
#       "step": "Confirm the lead vocalist of the identified rock band",
#       "queries": ["The lead vocalist of {{the rock band}}"]
#     }}    
#   ]
# }}

# **Output:** 
# <think> 
# Okay, let's analyze the clues step by step. The question mentions a rock band known for dramatic live performances, operatic-rock fusion, and a universally recognized sports anthem. Additionally, the band's lead vocalist is notable for an exceptional vocal range.

# Initially, several bands might fit this description, so I should perform some searches to narrow this down:
# </think>

# <|begin_search_queries|>
# Rock band known for dramatic live performances and operatic-rock fusion;
# Rock band with lead vocalist known for exceptional vocal range;
# Rock band anthem commonly played at sports events
# <|end_search_queries|>

# <|begin_search_results|>

# ... The described band is Queen. ...

# <|end_search_results|>

# <think>
# Given these strong clues, it could directly point towards Queen, particularly due to their operatic style, famously exemplified in the legendary album "A Night at the Opera”. Indeed, Queen's anthems like "We Will Rock You" and "We Are the Champions" are frequently played at sporting events. Their vocalist, Freddie Mercury, is widely celebrated for his exceptional vocal range and theatrical stage presence.

# To confirm this clearly, let's verify the lead vocalist of Queen explicitly:
# </think>

# <|begin_search_queries|>
# The lead vocalist of Queen
# <|end_search_queries|>

# <|begin_search_results|>

# ... The lead vocalist of Queen is Freddie Mercury. ...

# <|end_search_results|>

# <think>
# Given these confirmations, the band described by the clues is indeed Queen, and their iconic lead vocalist was Freddie Mercury.
# </think>

# **Final Answer:**
# \\boxed{{Freddie Mercury}}

# ---
# ### Now, generate your detailed reasoning answer based on the provided question and workflow.

# **Inputs:**

# - Question:  
# {question}

# - Workflow:  
# {workflow}

# **Output:**
# """