# Code Demo for "From Data to Model: Anomaly Detection of 3D GPR Data in CuDeRes Model Space"

This repository contains a demonstration code for the paper titled "From Data to Model: Anomaly Detection of 3D GPR Data in CuDeRes Model Space". 

## Structure

The repository is structured into two main directories:

- `data`: Due to file size limitations, the full dataset cannot be provided. Instead, this folder contains 10 blocks of 3D GPR data with pipeline anomalies for testing purposes.
- `code`: This folder contains the following files:
  - `CuDeRes.py`: Contains the definition of the CuDeRes network.
  - `normal_model_depot.npy`: Contains models fitted from 50 normal blocks of 3D GPR data, serving as a model depot.
  - `run.py`: Script to run and demonstrate the code. It fits the CuDeRes Model to the anomalous data and uses TSNE to visualize the class separability of the fitted models in 2D.

## Requirements

The following environment is recommended to run this code demo:
- Python: 3.6
- Torch: 1.10.0
- Numpy: 1.19.3

## Usage

To run the demo, execute the following command:

```bash
python run.py
