# import the opencv library
import cv2
import json
import glob
from pathlib import Path
from configs.paths import *
import os

pesron_name = "NAME"

paths = glob.glob(str(Path(project_path) / "recordings" / pesron_name / "*.avi"))

for file in paths:
    print(file)
    _, name = os.path.split(file)
    num = name.split("c")[-1]
    num = num.split(".")[0]

    # define a video capture object
    cap = cv2.VideoCapture(file)

    while(True):

        # Capture the video frame
        # by frame
        ret, frame = cap.read()

        # Display the resulting frame
        cv2.imshow('frame', frame)

        msec = cap.get(cv2.CAP_PROP_POS_MSEC)
        #print(msec/1000)

        # the 'q' button is set as the
        # quitting button you may use any
        # desired button of your choice
        key = cv2.waitKey(0)
        if key & 0xFF == ord('q'):
           break
        elif key & 0xFF == ord('s'):
            out_path = Path(project_path) / "recordings" / pesron_name / f"{num}.json"
            with open(out_path, "w") as f:
                json.dump({
                    "gt_hold": msec/1000
                }, f)

    # After the loop release the cap object
    cap.release()
    # Destroy all the windows
    cv2.destroyAllWindows()
