import json
from pathlib import Path
from configs.paths import *
import glob
import os
import numpy as np

robot_config_path = str(Path(project_path) / "configs" / "robot_timings.json")

with open(robot_config_path, "r") as f:
    robot_times = json.load(f)

person_name = "NAME"

model_paths = glob.glob(str(Path(project_path) / "recordings" / person_name / "*_*.json"))

wait_times = []
for path in model_paths:
    _, num = os.path.split(path)
    num = num.split("_")[-1]
    num = num.split(".")[0]

    gt_path = str(Path(project_path) / "recordings" / person_name / f"{num}.json")

    with open(path, "r") as f:
        model_times = json.load(f)
    with open(gt_path, "r") as f:
        gt_times = json.load(f)

    if(model_times["start_to_bottle"] < 0 and model_times["start_pour"] < 0):
        continue

    if(model_times["start_to_bottle"] > 0):
        bottle_grabed_time = model_times["start_to_bottle"] + robot_times["grab_bottle"]
    else:
        bottle_grabed_time = model_times["start_pour"] + robot_times["grab_bottle"]

    if model_times["start_pour"] > bottle_grabed_time:
        finished_pour_time = model_times["start_pour"] + robot_times["pour"]
    else:
        finished_pour_time = bottle_grabed_time + robot_times["pour"]

    wait_time = finished_pour_time - gt_times["gt_hold"]
    wait_times.append(wait_time)

wait_times = np.array(wait_times)

print(wait_times)
print(f"Mean {wait_times.mean()}, Dev {wait_times.std()}")
