import os
import torch

from configs.paths import project_path
from configs.cfg_to_info import default_opt, cfg_to_info

future_num = 0
run_name = "HOIBOT"
epoch = 39

file_dir = os.path.join(project_path, "weights/hoi4abot/f{}/f{}.{}")

opt = default_opt()
opt.cfg = file_dir.format(future_num, future_num, "yaml")
print("Loading configuration file:", opt.cfg)

checkpoint_file = file_dir.format(future_num, f"{future_num}_old", "pt")
print("Loading checkpoint file:", checkpoint_file)

info = cfg_to_info(opt)
old_state_dict = torch.load(checkpoint_file)

if "human_pos" in old_state_dict:
    old_state_dict["unionwrapper.human_pos"] = old_state_dict["human_pos"]
    old_state_dict.pop("human_pos")


state_dict = {"state_dict": old_state_dict,
              "info": info,
              "epoch": epoch,
              "run_name": run_name
              }

checkpoint_save = file_dir.format(future_num, future_num, "pt")
print("Saving in checkpoint file:", checkpoint_save)

torch.save(state_dict, checkpoint_save)
