# HOI4ABOT: Human-Object Interaction Anticipation for Human Intention Reading Assistive roBOTs 
## Introduction
This is the supplementary code for the submission in CORL2023 for the paper: 
HOI4ABOT: Human-Object Interaction Anticipation for Human Intention Reading Assistive roBOTs.

Next we detail the steps to reproduce the results. We also describe the instructions to run our model in real-time.

## Install


### Preparation of the environment

Create an environment using the provided ```environment.yaml``` file:
```commandline bash
conda env create -f environment.yaml
```

Additionally one needs to install CLIP as the semantic extractor following the instructions stated in OPENAI CLIP repository.

```
$ conda install --yes -c pytorch pytorch=1.7.1 torchvision cudatoolkit=11.0
$ pip install ftfy regex tqdm
$ pip install git+https://github.com/openai/CLIP.git
```
### Preparation of the dataset

Please consider visiting the following repository for details on the downloading of the dataset. We base our code on this implementation, as stated in our supplementary materials.
https://github.com/nizhf/hoi-prediction-gaze-transformer
In the aforementioned repository you will find: 
1. Code for the current state-of-the-art in HOI detection and anticipation in VidHOI dataset (Ni et Al, 2023)
2. Details on how to download and preprocess the VidHOI dataset.
3. Weights to compare our HOI4ABOT results with the aforementioned work (Ni et Al, 2023).


## Reproduction of the results
First it is required to adapt the ```configs/paths.py``` file by introducing the correct paths.

### Training
To execute the training, one first needs to download the VidHOI dataset and adapt the configuration file from ```/configs/train_hyp_f0_ours.yaml```.
The provided parameters belong to the best dual model for the detection mode. To train for the anticipation mode it is needed to change ```future_num=0``` and ```sampling_mode="anticipation"```.
Training command:
```commandline
python3 engine/train/train_vidhoi_HOI4ABOT.py --disable-wandb
```

### Evaluation
To execute the evaluation, one first needs to place the weidhts inside the ```weights/.``` directory and also copy the configuration file from ```/configs/train_hyp_f0_ours.yaml```.
Training command:
```commandline
python3 engine/train/train_vidhoi_HOI4ABOT.py --disable-wandb
```

### Evaluation
To execute the training, one first needs to download the VidHOI dataset and adapt the configuration file from ```/configs/train_hyp_f0_ours.yaml```.
The provided parameters belong to the best dual model for the detection mode. To train for the anticipation mode it is needed to change ```future_num=0``` and ```sampling_mode="anticipation"```.
Evaluation in the oracle mode:
```commandline
python3 engine/eval/eval_vidhoi_HOI4ABOT.py
```

Evaluation in the detection mode:
```commandline
python3 engine/eval/eval_inference_vidhoi_HOI4ABOT.py
```

This scripts generate a .json file. To obtain the definitive metrics one needs to run the following and adapt the paths correctly to the definite json file:
```commandline
python3 engine/eval/eval_metrics_vidhoi.py
```


### Demo
We provide a script to run the inference of HOI detection and anticipation in real-time.
In this repository we do not provide the code to reproduce the results in a robot, therefore, the variable ```use_ros=False``` by default.

Connect a RGB camera to your PC and run the following command to excute our HOI4ABOT framework in real-time.
```commandline
python3 demo/run_camera_tbar.py
```

By default, the HOI4ABOT weights with Hydra variant will be used. One can check other's variants by changing the parameters in the demo configuration file ```demo/config/config.py```.
The parameters to be modified are: modelname and weights_path.

### Evaluation of inference speed
Use the ```stats/comupute_params_*``` for the given scripts. One first needs to use ```stats/extract_batches.py``` to extract batches with differnet number of interactions each.
For that is required to download and prepare the VidHOI dataset.
