# import the opencv library
import cv2
from pathlib import Path
from configs.paths import *

# define a video capture object
cap = cv2.VideoCapture(0)
cap.set(cv2.CAP_PROP_AUTOFOCUS, 0)

frame_width = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
frame_height = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))
fps = cap.get(cv2.CAP_PROP_FPS)

print("w", frame_width)
print("h", frame_height)
print("fps", fps)

base_dir = Path(project_path) / "recordings" / "NAME"

for i in range(5):
    print(f"Starting {i}")
    out = cv2.VideoWriter(str(base_dir / f'rec{i}.avi'), cv2.VideoWriter_fourcc('M','J','P','G'), fps, (frame_width,frame_height))
    while(True):
        # Capture the video frame
        # by frame
        ret, frame = cap.read()

        out.write(frame)
        # Display the resulting frame
        cv2.imshow('frame', frame)

        # the 'q' button is set as the
        # quitting button you may use any
        # desired button of your choice
        if cv2.waitKey(1) & 0xFF == ord('q'):
           break

    out.release()
# After the loop release the cap object
cap.release()
# Destroy all the windows
cv2.destroyAllWindows()
