# Understanding and Improving Adversarial Robustness of Neural Probabilistic Circuits

This repository builds upon the implementation of the paper *Neural Probabilistic Circuits* and provides the code of the paper: **_Understanding and Improving Adversarial Robustness of Neural Probabilistic Circuits_**.

---

## Data Preparation

Clone this repository. The folder `visat-dataset-tools/configs` contains configuration files for various datasets:

- `mnist_dim_3_min_3_noise_1.json`:  
  Describes the attribute values associated with each image in the MNIST-Add3 dataset.
- `mnist_dim_3_min_3_noise_1_neighbor.json`:  
  Defines the high-probability nodes (i.e., \( V_y \)) and neighborhood nodes (i.e., \( \mathcal{N}(y, r) \)) for each class.
- `mnist_dim_5_min_5_noise_1.json`:  
  Describes the attribute values associated with each image in the MNIST-Add5 dataset.
- `mnist_dim_5_min_5_noise_1_neighbor.json`:  
  Defines the high-probability nodes (i.e., \( V_y \)) and neighborhood nodes (i.e., \( \mathcal{N}(y, r) \)) for each class.

Download the datasets from the following Zenodo link:  
🔗 https://zenodo.org/records/15465202  
Save the extracted folders directly into the current working directory.

---

## Model Training

To train the attribute recognition model and the probabilistic circuit, please follow the setup and training instructions provided in the repository of the paper:  **_Neural Probabilistic Circuits_**.

---

## Model Testing

1. **Download the adversarial attack library**  
   Clone the adversarial attack implementation from:  
   🔗 https://github.com/Harry24k/adversarial-attacks-pytorch  
   and save it under the `visat-models/` directory.

   Replace its attack files for PGD, PGDL2, and CW attacks with the files in the `visat-models/attacks`.

2. **Set the dataset prefix**  
   In `visat-models/header.py`, update the `dataset_prefix` variable to match the dataset you're using:
   - For **MNIST-Add3**, set:
     ```python
     dataset_prefix = "mnist_dim_3_min_3_noise_1"
     ```
   - For **MNIST-Add5**, set:
     ```python
     dataset_prefix = "mnist_dim_5_min_5_noise_1"
     ```

3. **Run the evaluation scripts**  
   Execute the following bash scripts to test **NPC** and **RNPC** under both benign and adversarial settings:

   ```bash
   cd visat-models/scripts
   ./mnist_dim_3_min_3_noise_1.bash
   ./mnist_dim_5_min_5_noise_1.bash