from configs.default_cifar10_configs import get_default_configs

def get_config():
  config = get_default_configs()

  # sampling
  sampling = config.sampling
  sampling.method = 'pc'
  sampling.predictor = 'reverse_diffusion'
  sampling.corrector = 'langevin'
  sampling.class_guidance = True
  sampling.start_round = 0
  evaluate = config.eval
  evaluate.batch_size = 512
  evaluate.num_samples = 5000

  # training
  training = config.training
  training.sde = 'vesde'
  training.continuous = True
  training.n_iters = 100001

  # model
  model = config.model
  model.name = '1234'
  model.classifier = 'unet_class'
  model.class_path = './no_calib/checkpoints/checkpoint_2.pth'
  model.score = 'ncsnpp'
  model.score_path = './work/checkpoints/checkpoint_13.pth'
  model.fourier_scale = 16
  model.scale_by_sigma = True
  model.ema_rate = 0.999
  model.normalization = 'GroupNorm'
  model.nonlinearity = 'swish'
  model.nf = 128
  model.ch_mult = (1, 2, 2, 2)
  model.num_res_blocks = 8
  model.attn_resolutions = (16,)
  model.resamp_with_conv = True
  model.conditional = True
  model.fir = True
  model.fir_kernel = [1, 3, 3, 1]
  model.skip_rescale = True
  model.resblock_type = 'biggan'
  model.progressive = 'none'
  model.progressive_input = 'residual'
  model.progressive_combine = 'sum'
  model.attention_type = 'ddpm'
  model.init_scale = 0.0
  model.conv_size = 3
  model.score_calib_lambda = 1e-3
  model.scale = 1.0

  return config