# Score-based Conditional Generation with Fewer Labeled Data by Self-calibrating Classifier Guidance

## Dependencies

Run the following to install necessary python packages to run the code

```
pip install -r requirements.txt
```

## Training

### Training unconditional SGMs:

```
### Cifar-10:
python3 main.py --config configs/cifar10/fully/uncond_score.py --mode train --workdir </path/to/workdir>

### Cifar-100:
python3 main.py --config configs/cifar100/fully/uncond_score.py --mode train --workdir </path/to/workdir>
```

### Training Classifiers:

- Splitting datasets for semi-supervised training:

```
python3 split_dataset.py <ratio of labeled data> <dataset>

### For example:
python3 split_dataset.py 0.20 CIFAR10
```

- Use the following command to train the classifiers:

```
### Cifar-10:
python3 main_class.py --config <config files under configs/cifar10> --workdir </path/to/workdir>

### Cifar-100:
python3 main_class.py --config <config files under configs/cifar100> --workdir </path/to/workdir>
```

## Sampling

- Set the `model.class_path` (for classifier) and `model.score_path` (for unconditional SGM) in the config files to be the checkpoints to load from.

- Use the following command to sample from CGSGMs:

```
### Cifar-10:
python3 sampling_class.py --config <config files under configs/cifar10> --eval_folder </path/to/eval_folder>

### Cifar-100:
python3 sampling_class.py --config <config files under configs/cifar100> --eval_folder </path/to/eval_folder>
```

## Evaluation

- Compute stats file for the training data:

```
### Cifar-10:
python3 get_stats.py --config configs/default_cifar10_configs.py

### Cifar-100:
python3 get_stats.py --config configs/default_cifar100_configs.py
```

- Evaluate generated data:

```
python3 evaluate_cond.py \
    --config <config files under configs/cifar10 or cifar100> \
    --eval_folder </path/to/eval_folder> \
    --eval_metrics <Evaluation metrics separated using comma. (FID, intra-FID, Acc, PRDC, CAS, Calib-Error, or all)> \
```