from configs.default_cifar100_configs import get_default_configs

def get_config():
  config = get_default_configs()
  config.training.batch_size = 100

  # sampling
  sampling = config.sampling
  sampling.method = 'pc'
  sampling.predictor = 'reverse_diffusion'
  sampling.corrector = 'langevin'
  sampling.class_guidance = True
  sampling.cond_score = False
  sampling.start_round = 0
  evaluate = config.eval
  evaluate.batch_size = 500
  evaluate.num_samples = 500

  # training
  training = config.training
  training.sde = 'vesde'
  training.continuous = True
  training.n_iters = 200001
  # training.reduce_mean = True

  evaluate = config.eval

  data = config.data
  data.dataset = 'CIFAR100_SEMI_005'
  data.mix = False

  # model
  model = config.model
  model.name = 'unet_class'
  model.classifier = 'unet_class'
  model.class_path = '../work/cifar100_calib_labeled_005_1/checkpoints/checkpoint_4.pth'
  model.score = 'ncsnpp'
  model.score_path = '../work/cifar100_uncond/checkpoints/checkpoint_12.pth'
  model.fourier_scale = 16
  model.scale_by_sigma = True
  model.ema_rate = 0.999
  model.normalization = 'GroupNorm'
  model.nonlinearity = 'swish'
  model.nf = 128
  model.ch_mult = (1, 2, 2, 2)
  model.num_res_blocks = 8
  model.attn_resolutions = (16,)
  model.resamp_with_conv = True
  model.conditional = True
  model.fir = True
  model.fir_kernel = [1, 3, 3, 1]
  model.skip_rescale = True
  model.resblock_type = 'biggan'
  model.progressive = 'none'
  model.progressive_input = 'residual'
  model.progressive_combine = 'sum'
  model.attention_type = 'ddpm'
  model.init_scale = 0.0
  model.conv_size = 3
  model.use_score = True
  model.score_calib_lambda = 1.0
  model.use_dlsm = False
  model.dlsm_lambda = 0.0
  model.weighting_dlsm = 0.0
  model.scale = 2.5

  optim = config.optim
  optim.weight_decay = 0.
  optim.optimizer = 'Adam'
  optim.lr = 2e-4
  optim.beta1 = 0.9
  optim.eps = 1e-8
  optim.warmup = 0
  optim.grad_clip = 1.

  return config