#pragma once

#include <bits/stdc++.h>
using namespace std;

void checkTrajectory(vector<pair<int, int>> & trajectory, int n_query)
{
    assert(trajectory.size() == n_query);
    set<int> full;
    for(int i=0; i<n_query; i++)full.insert(i);

    set<int> nodes;
    for(auto x : trajectory)nodes.insert(x.first);

    assert(full == nodes);

    set<int> prev;
    bool possible = true;
    for(auto x : trajectory)
    {
        if(x.second!=-1)
        {
            if(prev.count(x.second)!=1)
            {
                cout<<x.first<<" "<<x.second<<endl;
                possible=false;
            }
        }
        prev.insert(x.first);
    }
    assert(possible);
}


// multithread
void checkTrajectory(const std::vector<std::vector<std::pair<int, int>>>& trajectory,
                     int n_query)
{
    // just lets flatten everything and use the a
    std::vector<std::pair<int,int>> flat;
    flat.reserve(n_query);
    for (const auto& grp : trajectory) {
        for (const auto& p : grp) {
            flat.push_back(p);
        }
    }

    assert((int)flat.size() == n_query);

    std::set<int> full;
    for (int i = 0; i < n_query; ++i) full.insert(i);

    std::set<int> seen;
    for (const auto& x : flat) 
        seen.insert(x.first);

    assert(full == seen);

    std::set<int> prev;
    bool possible = true;
    for (const auto& x : flat) {
        int node   = x.first;
        int parent = x.second;
        if (parent != -1) {
            if (prev.count(parent) != 1) {
                std::cout << "Invalid parent reference: child=" 
                          << node << " parent=" << parent << "\n";
                possible = false;
            }
        }
        prev.insert(node);
    }
    assert(possible);
}