# Optimal Order Simple Regret for Gaussian Process Bandits

This repository is the official implementation of **Optimal Order Simple Regret for Gaussian Process Bandits**. 


## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```


## Experiments

The source code includes the following files:

 - `algorithms.py`: Contains all learning algorithm (IGP-UCB, MVR, GP-PI and GP-EI) classes and the corresponding routines

 - `function.py`: Contains the definition of the objective functions including Rosenbrock, Hartman3, and RKHS elements.

 - `main_synthetic_test_fct.py`, `main_rosenbrock.py`, `main_hartman.py`: each contains the main file which runs the experiment with the corresponding objective function.


At the beginning of each main file a run command example is provided that contains the various keyword arguments which may be passed to the experiment. Those include values such as the number of samples and the learning algorithm. For instance, the run command:

```example_rosenbrock_run
python3 main_rosenbrock.py -N 10 -n_samples 20 -n_points 30 -methods MVR GP_PI
```

runs the experiments on Rosenbrock test function for N = 10 exploration trials, for 20 times (the final figures shall be generated by averaging over these 20 experiments), where a discretization of the domain with M = 30 points is used. It will generate output values over all experiments for both of the specified learning algorithms, MVR and GP-PI. The output will be stored as a column in a .csv file, for each experiment. 


## Results

We have conducted experiments comparing the simple regret performance of Bayesian optimization algorithms on synthetically generated functions in RKHS and on two commonly used benchmark functions for Bayesian optimization: Hartman3 and Rosenbrock.

- Simple regret performance for synthetically generated functions in RKHS using Matérn (left) and squared exponential (right) kernel.

<p float="left">
  <img src="./figures/RKHS_Matern.png" width="400" />
  <img src="./figures/RKHS_SE.png" width="400" />
</p>

- Simple regret performance for the Hartman3 function using Matérn (left) and squared exponential (right) kernel.
<p float="left">
  <img src="./figures/Hartman_Matern_laplace.png" width="400" />
  <img src="./figures/Hartman_SE_laplace.png" width="400" />
</p>

More figures can be found in the `figures` repository as well as the main paper.

## Demos

For demonstration purposes, we provide two files: `main_demo_1.py` and `main_demo_2.py`.

To run the demos, run these commands:

- In 1d:

```demo (1d)
python3 main_demo_1.py
```

- In 2d:

```demo (2d)
python3 main_demo_2.py
```


## 
