import pymc3 as pm
import numpy as np
import json

name = "extrahard_MC_500_5_4"
data = np.load(pm.get_data(f"{name}.npz.npy"))
nt, nw, J = data.shape
where = np.where(data == 1)
dic = {
    int(i): {
        int(j): int(k)
        for j, k in zip(
            where[1][np.where(where[0] == i)],
            where[2][np.where(where[0] == i)],
        )
    }
    for i in range(nt)
}

with open(f"{name}.json", "w") as f:
    json.dump(dic, f)
