## Requirements

Install required packages:

```bash
pip install -r requirements.txt

pip install torch==2.1.0 torchvision==0.16.0 torchaudio==2.1.0 --index-url https://download.pytorch.org/whl/cu121

pip install torch-sparse==0.6.18 torch-scatter==2.1.2 -f https://data.pyg.org/whl/torch-2.1.0+cu121.html
```

## Training MELD

To train MELD on **unconditional** molecular generation (e.g., ZINC or QM9):

```
# task_name: 'ZINC', 'QM9'
python src/main.py --config-name=config.yaml \
  model.schedule_degree=2 \
  model.diffusion_noise_schedule='latent-learnable-schedule' \
  model.ensure_connected=True \
  dataset.task_name={target} \
  general.exp_name={exp_name} \
  general.save_model=True \
  train.batch_size={bs} \
  train.n_epochs={epochs} \
  train.lr={lr} \
  model.use_provided_drop_ids=True \
  model.diffusion_steps={steps} \
  model.unconditioned=True \
  train.use_ema=True
```

To train MELD on **multi-conditional** molecular generation (e.g., polymer dataset `O2-N2-CO2`):
```
# task_name: 'O2-N2-CO2' (polymer dataset)
python src/main.py --config-name=config.yaml \
  model.schedule_degree=2 \
  model.diffusion_noise_schedule='latent-property-learnable-schedule' \
  model.ensure_connected=True \
  dataset.task_name={target} \
  general.exp_name={exp_name} \
  general.save_model=True \
  train.batch_size={bs} \
  train.n_epochs={epochs} \
  train.lr={lr} \
  model.use_provided_drop_ids=True \
  model.diffusion_steps={steps}
```
