# --- gossip.py ---
import numpy as np

def random_sample_index(n, batch_size):
    idx = list(range(n))
    np.random.shuffle(idx)
    return idx[:batch_size]

def FastMix(x, W, K):
    m, d = x.shape
    count = 0
    u_old = x.copy()
    u = x.copy()
    delta = np.sqrt(1-np.sort(np.abs(np.linalg.eigvals(W)))[-2]**2)
    eta = (1-delta)/(1+delta)
    while count < K:
        u_new = (1+eta)*W@u - eta*u_old
        u_old, u = u, u_new
        count += 1
    return u

def AccGossip(x, L, K):
    m, d = x.shape
    count = 0
    eigenvalues = np.linalg.eigvalsh(L)
    nonzero = eigenvalues[np.abs(eigenvalues)>0]
    lambda_max = np.max(eigenvalues)
    lambda_min = np.min(nonzero)
    chi = lambda_max / lambda_min
    c1 = (np.sqrt(chi)-1)/(np.sqrt(chi)+1)
    c2 = (chi+1)/(chi-1)
    c3 = 2*chi/((1+chi)*lambda_max)
    u_old = x.copy()
    u = c2*(np.eye(m)-c3*L)@x
    a_old, a = 1, c2
    while count < K:
        a_new = 2*c2*a - a_old
        u_new = 2*c2*(np.eye(m)-c3*L)@u - u_old
        a_old, a = a, a_new
        u_old, u = u, u_new
        count += 1
    return x - u/a
