# --- main.py ---
import numpy as np
from data_loader import load_data
from graph_utils import build_adj_matrix, build_weights, build_laplacian
from algorithms import run_gteg, run_mcsvre, run_oadsvi, run_diverse

def main():
    m = 50
    init = 0
    graph = 'ring'
    Data_type = 'a9a'
    run_type = 'sample'
    if run_type == 'sample':
        run_max = 5e6
    elif run_type == 'time':
        run_max = 100000
    elif run_type == 'communication':
        run_max = 50000

    np.random.seed(100)

    a, b, d, n, z_star = load_data(Data_type, m)

    V = build_adj_matrix(m, graph)
    W = build_weights(V)
    L = build_laplacian(V)

    if init == 0:
        z_init = np.zeros((m,2*d))
    elif init == 'random':
        z_init = np.random.rand(m,2*d)

    loss_gteg, LIFO_gteg, time_gteg, comm_gteg = run_gteg(a, b, W, z_init, z_star, run_type, run_max, n)
    loss_mcsvre, LIFO_mcsvre, time_mcsvre, comm_mcsvre = run_mcsvre(a, b, W, z_init, z_star, run_type, run_max, n)
    loss_oadsvi, LIFO_oadsvi, time_oadsvi, comm_oadsvi = run_oadsvi(a, b, L, z_init, z_star, run_type, run_max, n)
    loss_diverse, LIFO_diverse, time_diverse, comm_diverse = run_diverse(a, b, W, z_init, z_star, run_type, run_max, n)

    if run_type == 'sample':
        np.savez(f'result_lfo_{Data_type}.npz',
                gteg1=LIFO_gteg, mcsvre1=LIFO_mcsvre, oadsvi1=LIFO_oadsvi, diverse1=LIFO_diverse,
                gteg2=loss_gteg, mcsvre2=loss_mcsvre, oadsvi2=loss_oadsvi, diverse2=loss_diverse)
    elif run_type == 'time':
        np.savez(f'result_time_{Data_type}.npz',
                gteg1=time_gteg, mcsvre1=time_mcsvre, oadsvi1=time_oadsvi, diverse1=time_diverse,
                gteg2=loss_gteg, mcsvre2=loss_mcsvre, oadsvi2=loss_oadsvi, diverse2=loss_diverse)
    elif run_type == 'communication':
        np.savez(f'result_comm_{Data_type}.npz',
                gteg1=comm_gteg, mcsvre1=comm_mcsvre, oadsvi1=comm_oadsvi, diverse1=comm_diverse,
                gteg2=loss_gteg, mcsvre2=loss_mcsvre, oadsvi2=loss_oadsvi, diverse2=loss_diverse)

if __name__ == '__main__':
    main()
