# --- objective.py ---
import numpy as np

class obj_function(object):
    def __init__(self, a, b):
        self.a = a
        self.b = b

    def value(self, z):
        d = np.shape(self.a)[1]
        batch_size = np.shape(self.b)[0]
        R1 = 0.2
        R2 = 0.2
        x = z[:d]
        y = z[d:]
        f = 0
        if batch_size == 0:
            return f
        else:
            for i in range(batch_size):
                f += (np.dot(x,(self.a[i]+ y)) - self.b[i])**2
            f = (f/batch_size + R1*np.linalg.norm(x)**2 - R2*np.linalg.norm(y)**2)/2
            return f

    def grad(self, z):
        d = np.shape(self.a)[1]
        batch_size = np.shape(self.b)[0]
        R1 = 0.2
        R2 = 0.2
        x = z[:d]
        y = z[d:]
        grad_x = 0
        grad_y = 0
        if batch_size == 0:
            grad = np.zeros(2*d)
            return grad
        else:
            for i in range(batch_size):
                grad_x += (np.dot(x, self.a[i] + y) - self.b[i])*(self.a[i] + y)
                grad_y += (np.dot(x, self.a[i] + y) - self.b[i])*x
            grad_x = grad_x/batch_size + R1*x
            grad_y = grad_y/batch_size - R2*y
            grad = np.concatenate((grad_x,-grad_y))
            return grad
