import numpy as np
import matplotlib.pyplot as plt
from matplotlib.ticker import ScalarFormatter

result_lfo_a9a = np.load('result_lfo_a9a.npz')

lfo_gteg = result_lfo_a9a['gteg1']
lfo_mcsvre = result_lfo_a9a['mcsvre1']
lfo_oadsvi = result_lfo_a9a['oadsvi1']
lfo_diverse = result_lfo_a9a['diverse1']
loss_gteg = result_lfo_a9a['gteg2']
loss_mcsvre = result_lfo_a9a['mcsvre2']
loss_oadsvi = result_lfo_a9a['oadsvi2']
loss_diverse = result_lfo_a9a['diverse2']

plt.figure(figsize=(12,10))
plt.plot(lfo_gteg, loss_gteg, 'black', label='GT-EG', linewidth=7, linestyle=':',markersize=10)
plt.plot(lfo_mcsvre, loss_mcsvre, 'blue', label='MC-SVRE', linewidth=7, linestyle='-.',markersize=10)
plt.plot(lfo_oadsvi, loss_oadsvi, 'green', label='OADSVI', linewidth=7, linestyle='--',markersize=10)
plt.plot(lfo_diverse, loss_diverse, 'red', label='DIVERSE', linewidth=7, linestyle='-',markersize=10)
plt.xticks(fontsize=30)
plt.yticks(fontsize=30)
plt.yscale('log')
plt.xlabel('LIFO calls', fontsize=30)
plt.ylabel(r'$\Vert \mathbf{z} - \mathbf{z}^*\Vert^2$', fontsize=30)
ax = plt.gca()  
ax.xaxis.set_major_formatter(ScalarFormatter(useMathText=True))
ax.ticklabel_format(style='sci', axis='x', scilimits=(0, 0))
ax.xaxis.offsetText.set_fontsize(30)  
plt.legend(fontsize=40, loc='upper right')

plt.savefig('result_LIFO_a9a.pdf',dpi=300,bbox_inches='tight') 