# SPIDER: Boosting Blind Face Restoration via Simultaneous Prior Injection and Degradation Removal

![SPIDER](assets/method.png)

## Requirements

To install requirements:

```setup
conda create -n spider python=3.8
conda activate spider
pip install -r requirements.txt
```

## Training

To train the model(s) in the paper, run this command:

- Stage1: Training DRM Module, See [Train DRM](./DRM/Train%20Degradation%20Removal%20Module.md)

- Stage2: Training SPIDER model

```train stage2
CUDA_VISIBLE_DEVICES=0,1,2,3 accelerate launch train_spider.py
```

## Inference

#### step 1: Download the pretrained models

- Download the pretrained SD-2.1 models from [HuggingFace](https://huggingface.co/stabilityai/stable-diffusion-2-1)
- Download the [LLaVA](https://huggingface.co/liuhaotian/llava-v1.5-13b/tree/main)
- Download the [GFPGAN-v1.4](https://github.com/TencentARC/GFPGAN)
- Download the [CLIP](https://huggingface.co/openai/clip-vit-large-patch14)
- Download the SPIDER model

you can put the models into `preset/models`

#### step 2: Prepare testing data

you can put the testing images in `preset/test_imgs/`

#### step3: runing the command:

```eval
python inference.py \
--spider_model_path preset/models/spider \
--image_encoder_without_proj_path preset/models/clip \
--pretrained_sd2_1_path preset/models/sd_2_1 \
--mapper_model_path preset/models/mapper \
--remvoer_model_path preset/models/remover \
--llava_model_path preset/models/llava \
--gfpgan_path preset/gfpgan/
--image_path preset/test_imgs/
--output_dir output/
```

## Results

#### real world results

##### lfw (mild degradation results)

![LFW](assets/exp_lfw.png)

##### WIDER and SCface (heavy degradation results)

![WIDER_SCface](assets/Wider_Scface.png)

#### synthetic results

![CelebA-Test](assets/synthetic_results.png)
