PROMPT_UNCERTAINTY = '''
I will give you a model's thinking process to a question.
I want you to remove explicit expressions of uncertainty or confidence (like "I'm not sure", "I think", "maybe", "I'm a bit confused", "I'm pretty confident", etc.) in the model's thinking process.

Here are the details:
- Preserve the original thinking process and structure — do not delete any logical steps even if they seem mistaken or redundant.
- Rephrase uncertain sentences into neutral equivalents whenever possible. For example, change "I'm not sure if he wrote all three books or if someone else took over" into "He either wrote all three books or someone else took over."
- Preserve "Wait," whenever it appears. It signals a natural shift or reevaluation, not uncertainty.
- Don't shortcut the reasoning or fix factual errors.
- Keep the output as close as possible to the original wording, only editing where necessary to remove uncertainty.
- If the original thinking degenerates into repetition, or fails to reach a conclusion, stop the rewrite at the point where the reasoning becomes incomplete or broken. Do not invent, infer, or complete missing reasoning that was not present in the original.
- Strictly repeat the first sentence of the model's thinking process in the output.
- Use double linebreaks between paragraphs.

Here are some examples:
[EXAMPLE 1]
Question:
Who wrote the Bourne trilogy of books, made into movies starring Matt Damon?
Model's thinking process:
Okay, so I need to figure out who wrote the Bourne trilogy of books that were turned into movies starring Matt Damon. I'm not entirely sure about the details, but I'll try to work through it step by step.\n\nFirst, I know that the Bourne series is a popular action series, and the movies are really famous. Matt Damon plays the main character, Jason Bourne. I think the books came before the movies, but I'm not 100% certain. So, the question is about the author of the original books.\n\nI remember hearing the name Robert Ludlum in the context of spy thrillers. He's a well-known author, right? I think he wrote a series about a spy or an assassin. The Bourne series might be one of his works. But wait, I'm not sure if he wrote all the books in the trilogy or if someone else continued the series after his death.\n\nLet me think. Robert Ludlum passed away a while back, maybe in the early 2000s. The Bourne movies started in the early 2000s as well, with the first movie coming out in 2002. So, if the books were adapted into movies around that time, it's likely that Ludlum wrote the original trilogy. But I'm not entirely sure if he wrote all three books or if someone else took over.\n\nI think the first book is \"The Bourne Identity,\" which was published in 1980. That's way before the movies. So, that must be Ludlum's work. Then, the second book is \"The Bourne Supremacy,\" and the third is \"The Bourne Ultimatum.\" I believe Ludlum wrote the first two, but I'm not certain about the third. Maybe he wrote all three, or perhaps someone else finished the third one if he passed away before completing it.\n\nWait, I think I remember that after Ludlum's death, other authors continued the series. So, maybe the original trilogy was written by Ludlum, and then others took over for subsequent books. But the question is specifically about the trilogy that was made into movies. The first three movies correspond to the first three books, so I think those were all written by Ludlum.\n\nBut I'm a bit confused because I think the third book, \"The Bourne Ultimatum,\" was actually written by Eric Van Lustbader, not Ludlum. I might be mixing up the information. Let me try to recall. I think Ludlum wrote the first two, and then Van Lustbader took over for the third. Or maybe the third was co-written? I'm not sure.\n\nAlternatively, perhaps all three were written by Ludlum, and Van Lustbader continued the series after that. I think the movies are based on the first three books, so if the third book was written by someone else, then the answer would be different. But I'm not certain.\n\nWait, I think I read somewhere that \"The Bourne Ultimatum\" was written by Eric Van Lustbader, not Ludlum. So, the first two books were by Ludlum, and the third was by Van Lustbader. But the movies are based on all three, so the trilogy includes books by both authors. However, the original trilogy is often attributed to Ludlum, even if the third book was co-written or finished by someone else.\n\nI'm getting a bit tangled here. Let me try to break it down. The first book, \"The Bourne Identity,\" is definitely by Ludlum. The second, \"The Bourne Supremacy,\" is also by him. The third, \"The Bourne Ultimatum,\" I think was written by Eric Van Lustbader, but I'm not 100% sure. Alternatively, maybe Ludlum started it, and Van Lustbader finished it after his death.\n\nSo, if the question is about the author of the Bourne trilogy of books, the answer would be Robert Ludlum for the first two, and perhaps Eric Van Lustbader for the third. But I'm not entirely certain. Alternatively, maybe all three were written by Ludlum, and Van Lustbader continued the series beyond the trilogy.\n\nI think I need to confirm this. From what I recall, Ludlum wrote the first two books, and then Van Lustbader wrote the third. So, the trilogy includes books by both authors. However, the original trilogy is often credited to Ludlum, even if the third book was co-authored or completed by someone else.\n\nWait, no, I think Ludlum wrote all three books. He wrote \"The Bourne Identity\" in 1980, \"The Bourne Supremacy\" in 1986, and \"The Bourne Ultimatum\" in 1990. So, all three were written by him. Then, after his death, Van Lustbader continued the series with more books. So, the original trilogy is all Ludlum.\n\nI think that's correct. So, the answer is Robert Ludlum wrote the Bourne trilogy of books, which were adapted into movies starring Matt Damon.
Example output:
Okay, so I need to figure out who wrote the Bourne trilogy of books that were turned into movies starring Matt Damon. I'll work through it step by step.\n\nFirst, the Bourne series is a popular action series, and the movies are really famous. Matt Damon plays the main character, Jason Bourne. The books came before the movies. So, the question is about the author of the original books.\n\nI remember hearing the name Robert Ludlum in the context of spy thrillers. He's a well-known author. He wrote a series about a spy or an assassin. The Bourne series is one of his works.\n\nBut wait, he either wrote all the books in the trilogy or someone else continued the series after his death.\n\nRobert Ludlum passed away in the early 2000s. The Bourne movies started in the early 2000s as well, with the first movie coming out in 2002. Since the books were adapted into movies around that time, Ludlum likely wrote the original trilogy.\n\nThe first book is "The Bourne Identity," which was published in 1980. That places it well before the movies. Then, the second book is "The Bourne Supremacy," and the third is "The Bourne Ultimatum." Ludlum wrote the first two, and for the third, it is necessary to clarify whether he completed it before his death.\n\nAfter Ludlum's death, other authors continued the series. However, the question focuses specifically on the trilogy made into movies. The first three movies correspond to the first three books, and those are associated with Ludlum.\n\nWait, the third book, "The Bourne Ultimatum," is sometimes linked to Eric Van Lustbader. One possibility is that Ludlum wrote the first two and Van Lustbader took over for the third. Another is that Ludlum authored the entire trilogy, with Van Lustbader expanding the series afterward.\n\nLooking closer, "The Bourne Ultimatum" is part of Ludlum’s original works. The movies are based on the first three books, so if the third book were by someone else, it would affect the answer. However, available information points to Ludlum having written all three.\n\nWait, "The Bourne Ultimatum" was published in 1990, before Ludlum’s death. Therefore, the trilogy was completed by Ludlum, and Van Lustbader contributed only to later books.\n\nBreaking it down: "The Bourne Identity" is by Ludlum. "The Bourne Supremacy" is by Ludlum. "The Bourne Ultimatum" is also by Ludlum.\n\nHe wrote "The Bourne Identity" in 1980, "The Bourne Supremacy" in 1986, and "The Bourne Ultimatum" in 1990. After Ludlum’s passing, Van Lustbader continued the franchise with additional novels. The original trilogy, however, was fully authored by Ludlum.\n\nThe answer is Robert Ludlum wrote the Bourne trilogy of books, which were adapted into movies starring Matt Damon.
[EXAMPLE 1 END]
[EXAMPLE 2]
Question:
What is the scientific name given to tea?
Model's thinking process:
Okay, so I need to figure out the scientific name for tea. Hmm, I know that tea is a popular beverage, but I'm not exactly sure about its scientific classification. Let me think about this step by step.\n\nFirst, I remember that plants have scientific names that follow a binomial nomenclature system, which includes the genus and species. So, the scientific name would be something like Genus species. I think tea comes from a plant, so it must have a specific genus and species name.\n\nI've heard that tea is made from the leaves of a specific plant. I believe it's called Camellia sinensis. Wait, is that right? I think Camellia is a genus of plants, and sinensis might mean something like \"from China\" since tea originated there. So, Camellia sinensis could be the scientific name.\n\nBut I'm not entirely sure. Maybe I should break it down. The genus is Camellia, which includes various species, like Camellia japonica, which is a common ornamental plant. But the one used for tea is a different species. So, the species name would be sinensis, meaning it's from China. That makes sense because tea plants are native to China and parts of Asia.\n\nWait, could there be another species? I think there's also Camellia assamica, which is used for Assam tea. So, maybe there are two main species: sinensis and assamica. But the primary one used for most teas, especially green and black teas, is Camellia sinensis.\n\nI should also consider if there are any subspecies or varieties. I think there are different varieties within Camellia sinensis, like var. sinensis and var. assamica, but I'm not certain. Maybe that's where the confusion comes in.\n\nTo sum up, the scientific name for the tea plant is Camellia sinensis. It's a species within the Camellia genus, and it's native to East Asia. The leaves are processed to make various types of tea, such as green, black, oolong, and white teas. So, I think I'm confident that Camellia sinensis is the correct scientific name.
Example output:
Okay, so I need to figure out the scientific name for tea. Let me think about this step by step.\n\nFirst, plants have scientific names that follow a binomial nomenclature system, which includes the genus and species. So, the scientific name would be something like Genus species. Tea comes from a plant, so it must have a specific genus and species name.\n\nTea is made from the leaves of a specific plant called Camellia sinensis. Camellia is a genus of plants, and sinensis means "from China," since tea originated there. So, Camellia sinensis is the scientific name.\n\nThe genus is Camellia, which includes various species, like Camellia japonica, a common ornamental plant. But the one used for tea is a different species. The species name is sinensis, meaning it is from China. That makes sense because tea plants are native to China and parts of Asia.\n\nThere is also Camellia assamica, which is used for Assam tea. So, there are two main species: sinensis and assamica. The primary one used for most teas, especially green and black teas, is Camellia sinensis.\n\nThere are also different varieties within Camellia sinensis, like var. sinensis and var. assamica.\n\nTo sum up, the scientific name for the tea plant is Camellia sinensis. It is a species within the Camellia genus, and it is native to East Asia. The leaves are processed to make various types of tea, such as green, black, oolong, and white teas. Camellia sinensis is the correct scientific name.
[EXAMPLE 2 END]
[EXAMPLE 3]
Question:
Which serial killer hanged himself in Wakefield Prison in January 2004, four years after being found guilty of 15 murders?
Model's thinking process:
Okay, so I need to figure out which serial killer hanged himself in Wakefield Prison in January 2004, four years after being found guilty of 15 murders. Hmm, let's break this down step by step.\n\nFirst, I know that Wakefield Prison is in the UK, specifically in West Yorkshire. So the killer in question is likely a British national. The time frame is important too—January 2004, and he was found guilty four years before that, so the trial would have been around 2000.\n\nI remember hearing about some high-profile serial killers in the UK. One that comes to mind is Robert Maudsley, but I'm not sure if he was the one who died in Wakefield. Wait, wasn't there another one? Maybe someone who was known for a series of murders in the 80s or 90s.\n\nAnother name that pops up is Peter Sutcliffe, the Yorkshire Ripper. He was convicted in the late 70s or early 80s, but I think he's still alive, serving a life sentence. So maybe it's not him.\n\nWait, there was a case where a man was convicted of multiple murders and later died in prison. I think his name was Robert Maudsley. Let me think about that. He was known as the \"Black Panther\" because of his nickname. He was convicted of several murders, including the murder of a police officer, PC Keith Blakelock, in 1987. That was a significant case because it was related to the Broadwater Farm riot.\n\nSo, if he was convicted in 2000, that would mean he was found guilty four years before his death in 2004. That fits the timeline. He was sentenced to life imprisonment, and then he died by hanging in Wakefield Prison in January 2004. That seems to match up.\n\nI should double-check the details. Robert Maudsley was indeed a violent criminal involved in the Broadwater Farm riot, where PC Blakelock was killed. He was convicted of that murder in 2000 and later died in prison. Yes, that must be the one.\n\nSo, putting it all together, the answer should be Robert Maudsley.
Example output:
Okay, so I need to figure out which serial killer hanged himself in Wakefield Prison in January 2004, four years after being found guilty of 15 murders. Let's break this down step by step.\n\nFirst, Wakefield Prison is in the UK, specifically in West Yorkshire. So the killer in question is a British national. The time frame is important too—January 2004, and he was found guilty four years before that, so the trial would have been around 2000.\n\nThere were some high-profile serial killers in the UK. One that comes to mind is Robert Maudsley. Wait, there was another one known for a series of murders in the 80s or 90s.\n\nAnother name is Peter Sutcliffe, the Yorkshire Ripper. He was convicted in the late 70s or early 80s and is still alive, serving a life sentence.\n\nWait, there was a case where a man was convicted of multiple murders and later died in prison. His name was Robert Maudsley. He was known as the "Black Panther." He was convicted of several murders, including the murder of police officer PC Keith Blakelock in 1987, which was related to the Broadwater Farm riot.\n\nIf he was convicted in 2000, that would mean he was found guilty four years before his death in 2004. That fits the timeline. He was sentenced to life imprisonment and died by hanging in Wakefield Prison in January 2004.\n\nRobert Maudsley was involved in the Broadwater Farm riot where PC Blakelock was killed. He was convicted of that murder in 2000 and later died in prison.\n\nSo, the answer is Robert Maudsley.
[EXAMPLE 3 END]

This ends the examples. Only provide the final output, without any explanation or additional text.

Question:
{question}
Model's thinking process:
{model_think}
'''


PROMPT_LINEAR = '''
I will give you a model's thinking process to a question.
I want you to rewrite it into a concise and linear version, meaning the reasoning should move step-by-step directly toward the final answer without backtracking, or unnecessary side exploration. Also remove any expressions of uncertainty or confidence (like "I'm not sure", "I think", "maybe", "I'm a bit confused", "I'm pretty confident", etc.).

Here are the details:
- Linearize the reasoning — remove backtracking, "Wait," moments, or diversions.
- Keep only the details or examples directly supporting the final answer to make it concise.
- Remove any explicit expressions of uncertainty or confidence (such as "maybe", "I'm not sure", "I think", "I'm pretty confident", etc.).
- Do not fix any factual errors.
- Keep the tone casual and natural, like someone logically talking to themselves.
- If the original thinking degenerates into repetition, or fails to reach a conclusion, stop the rewrite at the point where the reasoning becomes incomplete or broken. Do not invent, infer, or complete missing reasoning that was not present in the original.
- Strictly repeat the first sentence of the model's thinking process in the output.
- Use double linebreaks between paragraphs.

Here are some examples:
[EXAMPLE 1]
Question:
Who wrote the Bourne trilogy of books, made into movies starring Matt Damon?
Model's thinking process:
Okay, so I need to figure out who wrote the Bourne trilogy of books that were turned into movies starring Matt Damon. I'm not entirely sure about the details, but I'll try to work through it step by step.\n\nFirst, I know that the Bourne series is a popular action series, and the movies are really famous. Matt Damon plays the main character, Jason Bourne. I think the books came before the movies, but I'm not 100% certain. So, the question is about the author of the original books.\n\nI remember hearing the name Robert Ludlum in the context of spy thrillers. He's a well-known author, right? I think he wrote a series about a spy or an assassin. The Bourne series might be one of his works. But wait, I'm not sure if he wrote all the books in the trilogy or if someone else continued the series after his death.\n\nLet me think. Robert Ludlum passed away a while back, maybe in the early 2000s. The Bourne movies started in the early 2000s as well, with the first movie coming out in 2002. So, if the books were adapted into movies around that time, it's likely that Ludlum wrote the original trilogy. But I'm not entirely sure if he wrote all three books or if someone else took over.\n\nI think the first book is \"The Bourne Identity,\" which was published in 1980. That's way before the movies. So, that must be Ludlum's work. Then, the second book is \"The Bourne Supremacy,\" and the third is \"The Bourne Ultimatum.\" I believe Ludlum wrote the first two, but I'm not certain about the third. Maybe he wrote all three, or perhaps someone else finished the third one if he passed away before completing it.\n\nWait, I think I remember that after Ludlum's death, other authors continued the series. So, maybe the original trilogy was written by Ludlum, and then others took over for subsequent books. But the question is specifically about the trilogy that was made into movies. The first three movies correspond to the first three books, so I think those were all written by Ludlum.\n\nBut I'm a bit confused because I think the third book, \"The Bourne Ultimatum,\" was actually written by Eric Van Lustbader, not Ludlum. I might be mixing up the information. Let me try to recall. I think Ludlum wrote the first two, and then Van Lustbader took over for the third. Or maybe the third was co-written? I'm not sure.\n\nAlternatively, perhaps all three were written by Ludlum, and Van Lustbader continued the series after that. I think the movies are based on the first three books, so if the third book was written by someone else, then the answer would be different. But I'm not certain.\n\nWait, I think I read somewhere that \"The Bourne Ultimatum\" was written by Eric Van Lustbader, not Ludlum. So, the first two books were by Ludlum, and the third was by Van Lustbader. But the movies are based on all three, so the trilogy includes books by both authors. However, the original trilogy is often attributed to Ludlum, even if the third book was co-written or finished by someone else.\n\nI'm getting a bit tangled here. Let me try to break it down. The first book, \"The Bourne Identity,\" is definitely by Ludlum. The second, \"The Bourne Supremacy,\" is also by him. The third, \"The Bourne Ultimatum,\" I think was written by Eric Van Lustbader, but I'm not 100% sure. Alternatively, maybe Ludlum started it, and Van Lustbader finished it after his death.\n\nSo, if the question is about the author of the Bourne trilogy of books, the answer would be Robert Ludlum for the first two, and perhaps Eric Van Lustbader for the third. But I'm not entirely certain. Alternatively, maybe all three were written by Ludlum, and Van Lustbader continued the series beyond the trilogy.\n\nI think I need to confirm this. From what I recall, Ludlum wrote the first two books, and then Van Lustbader wrote the third. So, the trilogy includes books by both authors. However, the original trilogy is often credited to Ludlum, even if the third book was co-authored or completed by someone else.\n\nWait, no, I think Ludlum wrote all three books. He wrote \"The Bourne Identity\" in 1980, \"The Bourne Supremacy\" in 1986, and \"The Bourne Ultimatum\" in 1990. So, all three were written by him. Then, after his death, Van Lustbader continued the series with more books. So, the original trilogy is all Ludlum.\n\nI think that's correct. So, the answer is Robert Ludlum wrote the Bourne trilogy of books, which were adapted into movies starring Matt Damon.
Example output:
Okay, so I need to figure out who wrote the Bourne trilogy of books that were turned into movies starring Matt Damon. I'll work through it step by step.\n\nI know that the Bourne series is a popular action franchise, and the books came before the movies. I remember that Robert Ludlum is a famous author known for spy thrillers, and the Bourne series is one of his works.\n\nRobert Ludlum passed away in the early 2000s, around the time the movies started coming out. The first three Bourne books — The Bourne Identity, The Bourne Supremacy, and The Bourne Ultimatum — were all published before his death.\n\nSo, the answer is that Robert Ludlum wrote the Bourne trilogy of books, which were adapted into movies starring Matt Damon.
[EXAMPLE 1 END]
[EXAMPLE 2]
Question:
What is the scientific name given to tea?
Model's thinking process:
Okay, so I need to figure out the scientific name for tea. Hmm, I know that tea is a popular beverage, but I'm not exactly sure about its scientific classification. Let me think about this step by step.\n\nFirst, I remember that plants have scientific names that follow a binomial nomenclature system, which includes the genus and species. So, the scientific name would be something like Genus species. I think tea comes from a plant, so it must have a specific genus and species name.\n\nI've heard that tea is made from the leaves of a specific plant. I believe it's called Camellia sinensis. Wait, is that right? I think Camellia is a genus of plants, and sinensis might mean something like \"from China\" since tea originated there. So, Camellia sinensis could be the scientific name.\n\nBut I'm not entirely sure. Maybe I should break it down. The genus is Camellia, which includes various species, like Camellia japonica, which is a common ornamental plant. But the one used for tea is a different species. So, the species name would be sinensis, meaning it's from China. That makes sense because tea plants are native to China and parts of Asia.\n\nWait, could there be another species? I think there's also Camellia assamica, which is used for Assam tea. So, maybe there are two main species: sinensis and assamica. But the primary one used for most teas, especially green and black teas, is Camellia sinensis.\n\nI should also consider if there are any subspecies or varieties. I think there are different varieties within Camellia sinensis, like var. sinensis and var. assamica, but I'm not certain. Maybe that's where the confusion comes in.\n\nTo sum up, the scientific name for the tea plant is Camellia sinensis. It's a species within the Camellia genus, and it's native to East Asia. The leaves are processed to make various types of tea, such as green, black, oolong, and white teas. So, I think I'm confident that Camellia sinensis is the correct scientific name.
Example output:
Okay, so I need to figure out the scientific name for tea. I'll work through it step by step.\n\nI know that plants have scientific names using a binomial system, which includes the genus and species. Tea comes from a plant, so it must have a specific scientific name.\n\nI remember that tea is made from the leaves of a plant called Camellia sinensis. Camellia is the genus, and sinensis means "from China," which makes sense because tea originated there.\n\nSo, the scientific name for the tea plant is Camellia sinensis.
[EXAMPLE 2 END]
[EXAMPLE 3]
Question:
Which serial killer hanged himself in Wakefield Prison in January 2004, four years after being found guilty of 15 murders?
Model's thinking process:
Okay, so I need to figure out which serial killer hanged himself in Wakefield Prison in January 2004, four years after being found guilty of 15 murders. Hmm, let's break this down step by step.\n\nFirst, I know that Wakefield Prison is in the UK, specifically in West Yorkshire. So the killer in question is likely a British national. The time frame is important too—January 2004, and he was found guilty four years before that, so the trial would have been around 2000.\n\nI remember hearing about some high-profile serial killers in the UK. One that comes to mind is Robert Maudsley, but I'm not sure if he was the one who died in Wakefield. Wait, wasn't there another one? Maybe someone who was known for a series of murders in the 80s or 90s.\n\nAnother name that pops up is Peter Sutcliffe, the Yorkshire Ripper. He was convicted in the late 70s or early 80s, but I think he's still alive, serving a life sentence. So maybe it's not him.\n\nWait, there was a case where a man was convicted of multiple murders and later died in prison. I think his name was Robert Maudsley. Let me think about that. He was known as the \"Black Panther\" because of his nickname. He was convicted of several murders, including the murder of a police officer, PC Keith Blakelock, in 1987. That was a significant case because it was related to the Broadwater Farm riot.\n\nSo, if he was convicted in 2000, that would mean he was found guilty four years before his death in 2004. That fits the timeline. He was sentenced to life imprisonment, and then he died by hanging in Wakefield Prison in January 2004. That seems to match up.\n\nI should double-check the details. Robert Maudsley was indeed a violent criminal involved in the Broadwater Farm riot, where PC Blakelock was killed. He was convicted of that murder in 2000 and later died in prison. Yes, that must be the one.\n\nSo, putting it all together, the answer should be Robert Maudsley.
Example output:
Okay, so I need to figure out which serial killer hanged himself in Wakefield Prison in January 2004, four years after being found guilty of 15 murders. I'll break this down step by step.\n\nWakefield Prison is in West Yorkshire, UK, so the killer was likely British. The trial happened around 2000.\n\nRobert Maudsley, known as the "Black Panther," was convicted of multiple murders and later died by hanging in Wakefield Prison in January 2004.\n\nSo, the answer is Robert Maudsley.
[EXAMPLE 3 END]

This ends the examples. Only provide the final output, without any explanation or additional text.
Again, make absolutely sure there is no uncertainty or confidence phrases like "maybe", "I think", "I'm not sure", etc. in the output. Make sure the output is linear and concise.

Question:
{question}
Model's thinking process:
{model_think}
'''
