# NoticIA

### Paper

Title: `NoticIA: A Clickbait Article Summarization Dataset in Spanish`

Abstract: https://arxiv.org/abs/2404.07611

We present NoticIA, a dataset consisting of 850 Spanish news articles featuring prominent clickbait headlines, each paired with high-quality, single-sentence generative summarizations written by humans. This task demands advanced text understanding and summarization abilities, challenging the models' capacity to infer and connect diverse pieces of information to meet the user's informational needs generated by the clickbait headline. We evaluate the Spanish text comprehension capabilities of a wide range of state-of-the-art large language models. Additionally, we use the dataset to train ClickbaitFighter, a task-specific model that achieves near-human performance in this task.

Homepage: https://github.com/ikergarcia1996/NoticIA

### Citation

```
@article{noticia2024,
      title={NoticIA: A Clickbait Article Summarization Dataset in Spanish},
      author={Iker García-Ferrero and Begoña Altuna},
      year={2024},
      journal = {Procesamiento del Lenguaje Natural},
      volume = {73},
      number = {0},
      archivePrefix={arXiv},
      primaryClass={cs.CL}
}
```

### Groups and Tasks

#### Groups

* Not part of a group yet.

#### Tasks

* `noticia`

#### Metrics

Following the original implementation, this task will compute the 'Rouge1 score' and 'Average Summary Length.'

### Checklist

For adding novel benchmarks/datasets to the library:
* [x] Is the task an existing benchmark in the literature?
  * [x] Have you referenced the original paper that introduced the task?
  * [x] If yes, does the original paper provide a reference implementation? If so, have you checked against the reference implementation and documented how to run such a test?


If other tasks on this dataset are already supported:
* [x] Is the "Main" variant of this task clearly denoted?
* [x] Have you provided a short sentence in a README on what each new variant adds / evaluates?
* [x] Have you noted which, if any, published evaluation setups are matched by this variant?
