#!/usr/bin/python
# -*- coding: UTF-8 -*-
from typing import List, Union

import numpy as np
from CDAF import CDAf1
import random
import math


def BTSwCDf1(EPOP, Epal):
    n = len(Epal[0])
    m = len(EPOP)
    p = len(EPOP[0])
    NPOP = np.zeros((m, p))
    Npal = np.zeros((m, n + 1))
    Epa = np.zeros((m, n + 1))
    Epa[:, 0:2] = Epal[:, 0:2]
    Epa[:, 2] = Epal[:, 2]
    for i in range(0, len(Epa)):
        if np.isnan(Epa[i, 0]):
            print('Epa0' + str(i), Epa[i, 0])
        if np.isnan(Epa[i, 1]):
            print('Epa1' + str(i), Epa[i, 1])
    for i in range(0, int(max(Epa[:, 2]))):
        idx = [k for k, x in enumerate(Epa[:, 2]) if x == i]
        if len(idx):
            tpa = Epa[idx, 0:2]
            tPOP = EPOP[idx]
            # print(' BTSwCDFtpa=', tpa)
            for i in range(0, len(tpa)):
                if np.isnan(tpa[i, 0]):
                    print('tpa0' + str(i), tpa[i, 0])
                if np.isnan(Epa[i, 1]):
                    print('tpa1' + str(i), tpa[i, 1])
            ttPOP, ttpa, ttI = CDAf1(tPOP, tpa)  # calculate crowding-distancein Fi
            EPOP[idx] = ttPOP
            Epa[idx, 0:2] = ttpa
            Epa[idx, 2] = (i + np.zeros((len(idx), 1))).squeeze()
            Epa[idx, 3] = ttI.squeeze()
        else:
            continue
    for i in range(0, m):
        NPOP[i, :] = EPOP[i, :]
        Npal[i, :] = Epa[i, :]
        b1 = math.ceil((random.random() * (m - 0.5) + 0.5))
        if b1 != i:
            if Epa[i, n - 1] > Epa[b1 - 1, n - 1]:
                NPOP[i, :] = EPOP[b1 - 1, :]
                Npal[i, :] = Epa[b1 - 1, :]
            elif (Epa[i, n - 1] == Epa[b1 - 1, n - 1]) and (Epa[i, n] > Epa[b1 - 1, n]):
                NPOP[i, :] = EPOP[b1 - 1, :]
                Npal[i, :] = Epa[b1 - 1, :]
    return NPOP
