#!/usr/bin/python
# -*- coding: UTF-8 -*-

from Bayobjective4 import objective4
import numpy as np

from hyperopt import hp 
space = {
    'lamda': hp.uniform('lamda', 0, 1),
    'mut_rate': hp.uniform('mut_rate', 0, 1), 
    'min_model': hp.quniform('min_model', 1, 4, 1),
}

from hyperopt import fmin, tpe
tpe_algo = tpe.suggest
from hyperopt import Trials
tpe_trials = Trials()
tpe_best = fmin(fn=objective4, space=space, algo=tpe_algo, trials=tpe_trials,
                max_evals=5)

print(tpe_best)
print('Minimum loss attained with TPE:    {:.4f}'.format(tpe_trials.best_trial['result']['loss']))
print('\nNumber of trials needed to attain minimum with TPE(lamda):    {}'.format(tpe_trials.best_trial['misc']['idxs']['lamda'][0]))
print('\nNumber of trials needed to attain minimum with TPE(mut_rate):    {}'.format(tpe_trials.best_trial['misc']['idxs']['mut_rate'][0]))
print('\nNumber of trials needed to attain minimum with TPE(min_model):    {}'.format(tpe_trials.best_trial['misc']['idxs']['min_model'][0]))

print('\nBest value of lamda from TPE:    {:.4f}'.format(tpe_best['lamda']))
print('\nBest value of mut_rate from TPE:    {:.4f}'.format(tpe_best['mut_rate']))
print('\nBest value of min_model from TPE:    {:.4f}'.format(tpe_best['min_model']))

loss ='Minimum loss attained with TPE:' + str(tpe_trials.best_trial['result']['loss']) + '\n'
trials1='Number of trials needed to attain minimum with TPE(lamda):' + str(tpe_trials.best_trial['misc']['idxs']['lamda'][0]) + '\n'
trials2='Number of trials needed to attain minimum with TPE(mut_rate):' + str(tpe_trials.best_trial['misc']['idxs']['mut_rate'][0]) + '\n'
trials3='Number of trials needed to attain minimum with TPE(min_model):' + str(tpe_trials.best_trial['misc']['idxs']['min_model'][0]) + '\n'

slamda='Best value of lamda from TPE:' + str(tpe_best['lamda']) + '\n'
smut_rate='Best value of mut_rate from TPE:' + str(tpe_best['mut_rate']) + '\n'
smin_model='Best value of min_model from TPE:' + str(tpe_best['min_model']) + '\n'

ftxt = open('result.txt', 'a')
ftxt.write(loss)
ftxt.write(trials1)
ftxt.write(trials2)
ftxt.write(trials3)

ftxt.write(slamda)
ftxt.write(smut_rate)
ftxt.write(smin_model)

ftxt.close()