#!/usr/bin/python
# -*- coding: UTF-8 -*-


import numpy as np


def CDAf1(tPOP, tpa):
    m = len(tpa)
    n = len(tpa[0])
    padis = []
    tp = np.zeros((m, 1))
    for i in range(0, n):
        y = tpa[:, i].argsort()
        N = tpa[y, :]
        M = tPOP[y, :]
        tp = tp[y]
        tpa = N
        tPOP = M
        tp[0, 0] = float("inf")
        tp[m - 1, 0] = float("inf")
        if m == 1 or m == 2:
            tpai1 = tpa[:, i]
            tpad1 = tpa[:, i]
        else:
            tpai1 = tpa[2:m, i]
            tpad1 = tpa[0:(m - 2), i]
        tpai1 = tpai1.flatten()
        tpad1 = tpad1.flatten()
        fimin = min(tpa[:, i])
        fimax = max(tpa[:, i])
        a = abs(tpai1 - tpad1)
        if a.any() == 0:
            tp[1:(m - 1), 0] = tp[1:(m - 1), 0]
        else:
            tp[1:(m - 1), 0] = tp[1:(m - 1), 0] + a / (0.0001 + fimax - fimin)

    pa = tpa
    pop = tPOP
    padis = tp

    return pop, pa, padis
