#!/usr/bin/python
# -*- coding: UTF-8 -*-

import numpy as np


def Confidence_Calibration_Calculation(Pro, ind, M):
    label = np.zeros(len(ind))
    Pro_label = np.zeros(len(ind))
    for j in range(0, len(ind)):
        I = np.argmax(Pro[j, :])
        label[j] = I + 1
    for i in range(0, len(ind)):
        Pro_label[i] = Pro[i, int(ind[i] - 1)]
    Group_label = np.zeros(len(ind))
    for i in range(0, len(ind)):
        for j in range(0, M):
            if Pro_label[i] > j / M and Pro_label[i] <= (j + 1) / M:
                Group_label[i] = j + 1
    total = []
    ACC = []
    Conf = []
    for i in range(0, M):
        total_num = 0
        true_num = 0
        Pro = 0
        for j in range(0, len(ind)):
            if Group_label[j] == i + 1:
                Pro = Pro + Pro_label[j]
                total_num = total_num + 1
                if label[j] == ind[j]:
                    true_num = true_num + 1
        if total_num == 0:
            total_num = 1
        total.append(total_num)
        ACC.append(true_num / total_num)
        Conf.append(Pro / total_num)
    ECE = 0
    MCE = 0
    for i in range(0, M):
        ECE = ECE + (total[i] / len(ind)) * abs(ACC[i] - Conf[i])
        tmp_MCE = abs(ACC[i] - Conf[i])
        if tmp_MCE > MCE:
            MCE = tmp_MCE
    return ECE, MCE
