#!/usr/bin/python
# -*- coding: UTF-8 -*-

import numpy as np
from sklearn.metrics import roc_curve, auc

def cal_evaluation1(P,ind):
    TP = 0
    FP = 0
    TN = 0
    FN = 0
    label = np.zeros((len(ind), 1))
    for i in range (0,len(ind)):
        label[i] = np.argmax(P[i,:])

    for m in range(0,len(ind)):
        if label[m] == ind[m] and label[m] == 1:
            TP = TP + 1
        if label[m] == ind[m] and label[m] == 0:
            TN = TN + 1
        if label[m] == 1 and ind[m] == 0:
            FP = FP + 1
        if label[m] == 0 and ind[m] == 1:
            FN = FN + 1
    AUC_pro=P[:,1]
    fpr, tpr, thresholds = roc_curve(ind, AUC_pro, pos_label=1)
    AUC = auc(fpr, tpr)
    sen = TP / (TP + FN)
    spe = TN / (TN + FP)
    acc = (TP + TN) / len(ind)
    return sen,spe,acc,AUC
        




