#!/usr/bin/python
# -*- coding: UTF-8 -*-

import numpy as np


def cal_weight1(pareto, AUC, lamda):
    w = np.zeros((len(pareto), 1))
    for j in range(0, len(pareto)):
        if pareto[j, 0] >= pareto[j, 1]:
            w[j] = pareto[j, 1] / pareto[j, 0]
        else:
            w[j] = pareto[j, 0] / pareto[j, 1]
        w[j] = lamda * w[j] + (AUC[j] / max(AUC)) * [1 - lamda]
    t = sum(w)
    for i in range(0, len(pareto)):
        w[i] = w[i] / t
        w[i] = round(w[i][0],4)
    return w

