import os, json, pickle, re
import networkx as nx


def get_depend_graph(design_name):
    print('Current Design: ', design_name)
    ep_lst_path = f"/home/coguest5/CircuitFusion/data_collect/label/ep_lst/{design_name}.json"
    with open(ep_lst_path, 'r') as f:
        ep_lst = json.load(f)
    
    design_graph_dir = f"/home/coguest5/CircuitFusion/data_collect/dataset/rtl_graph/ori/"
    with open(f"{design_graph_dir}/{design}_ori.pkl", 'rb') as f:
        design_graph = pickle.load(f)
    with open(f"{design_graph_dir}/{design}_ori_node_dict.pkl", 'rb') as f:
        node_dict = pickle.load(f)
    
    g = nx.DiGraph(design_graph)

    #### check path from each ep to each ep
    

    ### replace node name with ep name
    map_dict = {}
    for node in g.nodes():
        node_new = re.sub(r'\\\\', '', node)
        node_new = re.sub(r'\\', '', node)
        node_new = re.sub(r'\.', '_', node_new)
        node_dict[node_new] = node_dict.pop(node)
        node_new = re.sub(r'_PTR(\d+)$', '', node_new)
        node_new = re.sub(r'_PS(\d+)_(\d+)$', '', node_new)
        map_dict[node] = node_new

    # print(map_dict)
    g = nx.relabel_nodes(g, map_dict)


    ### create new graph with only ep nodes
    g_ep = nx.DiGraph()
    node_dict_ep = {}
    idx = 0
    for ep in ep_lst:
        for ep_ in ep_lst:
            if nx.has_path(g, ep, ep_):
                # print(f"Path from {ep} to {ep_} exists.")
                ### add edge to g_ep
                g_ep.add_edge(ep, ep_)
                idx += 1
                node_dict_ep[ep] = node_dict[ep]
                node_dict_ep[ep_] = node_dict[ep_]
            else:
                # print(f"Path from {ep} to {ep_} does not exist.")
                pass
    print(idx)
    print(len(ep_lst))
    print(g_ep)
    # print(node_dict_ep)
    print(len(node_dict_ep))
    assert len(g_ep.nodes) == len(ep_lst)
    assert len(node_dict_ep) >= len(ep_lst)

    save_dir = f"../data/"
    with open(f"{save_dir}/{design_name}_ep_graph.pkl", 'wb') as f:
        pickle.dump(g_ep, f)
    with open(f"{save_dir}/{design_name}_ep_node_dict.pkl", 'wb') as f:
        pickle.dump(node_dict_ep, f)





if __name__ == "__main__":

    with open("/home/coguest5/CircuitFusion/data_collect/dataset/json/design_lst/design_lst.json", 'r') as f:
        design_lst = json.load(f)

    for design in design_lst:
        get_depend_graph(design)
