import json, pickle, re, os
from DG import *

def run_one_design(bench, design_name):
    print(bench, design_name)
    design_path = f"/home/coguest5/rtl_repr/LS-benchmark/{bench}/flatten/{design_name}_flatten.v"

    if not os.path.exists(f"/home/coguest5/rtl_repr/LS-benchmark/{bench}/coi"):
        os.makedirs(f"/home/coguest5/rtl_repr/LS-benchmark/{bench}/coi")
    
    new_design_path = f"/home/coguest5/rtl_repr/LS-benchmark/{bench}/coi/{design_name}_flatten.v"

    with open(design_path, 'r') as f:
        lines = f.readlines()
    
    with open(new_design_path, 'w') as f:
        
        for line in lines:
            comment_re = re.findall(r"(.*)//(.*)", line)
            if comment_re:
                line = comment_re[0][0] + '\n'
                print(line)
                input() 
            line = re.sub(r'\\', '', line)
            line = re.sub(r'\.', '_', line)
            f.writelines(line)


    design_dict_path = f"/home/coguest5/rtl_repr/AST_analyzer/graph_data/{design_name}_flatten_node_dict.pkl"
    with open(design_dict_path, 'rb') as f:
        design_dict = pickle.load(f)
    
    reg_lst = []
    for name, node in design_dict.items():
        if node.type in ['Reg']:
            name = re.sub(r'\\', '', name)
            name = re.sub(r'\.', '_', name)
            if re.findall(r"\[(.*)\]", name):
                continue
            reg_lst.append(name)
    
    print(reg_lst)
    with open(f"../data/reg_lst/{design_name}.json", 'w') as f:
        json.dump(reg_lst, f)

    



if __name__ == '__main__':
    bench_dict = {}
    design_json = "/home/coguest5/rtl_repr/LS-benchmark/design.json"
    bench_list = ['itc','opencores','VexRiscv','chipyard', 'riscvcores','NVDLA']

    design_name = ''

    for bench in bench_list:
        with open(design_json, 'r') as f:
            design_data = json.load(f)
            dir_ = design_data[bench]
            for k, v in dir_.items():
                if design_name:
                    if k == design_name:
                        run_one_design(bench, design_name)
                else:
                    run_one_design(bench, k)