import json, os, re

def vlg_clean(file):
    file_tmp = file + ".tmp"
    os.system("cp {0} {1}".format(file, file_tmp))
    os.remove(file)
    with open(file_tmp, "r") as f:
        lines = f.readlines()
        with open(file, "a+") as f_tmp:
            for line in lines:
                line = re.sub(r'\(\*(.*)\*\)', '', line)
                if line.strip():
                    f_tmp.writelines(line)
    os.remove(file_tmp)

def convert_one_design(design, output_dir):
    design_dir = f"./ori/{design}.v"
    print('Current Design: ', design)
    design_vec = design_dict[design]
    design_top = design_vec[0]

    ys_scr = f"./transform_{design}.ys"
    with open(ys_scr, 'w') as f:
        f.writelines(f"read_verilog -sv {design_dir}\n")
        f.writelines(f"hierarchy -check -top {design_top}\nproc\n")
        f.writelines("opt_expr\n")
        f.writelines("opt_merge\n")
        f.writelines("opt_reduce\n")
        f.writelines("opt_clean\n")
        f.writelines(f"write_verilog {output_dir}/{design}.v\n")

    os.system(f"yosys -s {ys_scr}")
    vlg_clean(f"{output_dir}/{design}.v")
    vlg_clean(f"{design_dir}")
    os.remove(ys_scr)

if __name__ == '__main__':

    global cmd
    cmd = "pos"

    global design_dict
    design_dict = {}
    with open ("/home/coguest5/LS-benchmark/design.json", 'r') as f:
        design_js = json.load(f)
    for bench, design in design_js.items():
        design_dict = {**design_dict, **design}

    with open("../json/design_lst/design_lst.json", 'r') as f:
        design_lst = json.load(f)
    
    
    for design in design_lst:
        output_dir = f'./{cmd}/'
        convert_one_design(design, output_dir)
