from __future__ import absolute_import
from __future__ import print_function
import sys
import os, time, json, re, pickle
from optparse import OptionParser
import networkx as nx
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
import pyverilog
from pyverilog.vparser.parser import parse
from AST_analyzer import *
from AST_analyzer import AST_analyzer
from multiprocessing import Pool

def run_one_design(design_name):

    with open (f"../json/{design_name}.json", 'r') as f:
        ep_lst_dict = json.load(f)
    
    for ep in ep_lst_dict.keys():
        print(ep)
        run_one_ep(design_name, ep)

def run_one_ep(design_name, ep):

    print('Current Design:', design_name)
    design_dir = f'../ori/vlg/{design_name}/{ep}.syn.v'
    filelist = [design_dir]

    for f in filelist:
        if not os.path.exists(f):
            # return
            raise IOError("file not found: " + f)
        


    ast, directives = parse(filelist)
    print('Verilog2AST Finish!')
    ast_analysis = AST_analyzer(ast)
    
    ast_analysis.AST2Graph(ast)
    g, node_dict, dff_set = ast_analysis.graph2dff_lst(design_name)

    save_dir = f"../../ori/graph/{design_name}/"

    g_nx = nx.DiGraph(g)
    print(g_nx)

    if not os.path.exists(save_dir):
        os.makedirs(save_dir)
    with open (f"{save_dir}/{ep}_graph.pkl", 'wb') as f:
        pickle.dump(g, f)
    with open (f"{save_dir}/{ep}_node_dict.pkl", 'wb') as f:
        pickle.dump(node_dict, f)



if __name__ == '__main__':
    design_js_path = "/home/coguest5/rtl_repr/data_collect/dataset/json/design_lst/design_lst_p1.json"
    with open (design_js_path, 'r') as f:
        design_lst = json.load(f)
    
    run_one_design('b22')
    # for design in design_lst:
    #     run_one_design(design)