import json, pickle, re
import networkx as nx
import DG

def get_node_tpe(node_name, node_dict):
    tpe_ = 0
    if not node_name in node_dict:
        print(node_name)
        tpe_ = 0
        return tpe_
    
    node_class = node_dict[node_name]
    node_tpe_ori = node_class.type
    if node_tpe_ori in ['Reg']:
        tpe_ = 1
    elif node_tpe_ori in ['Input', 'Inout']:
        tpe_ = 2
    elif node_tpe_ori in ['Output']:
        tpe_ = 3
    elif node_tpe_ori in ['Wire']:
        tpe_ = 4
    elif node_tpe_ori in ['Operator', 'UnaryOperator', 'Concat', 'Repeat']:
        op_temp = re.findall(r'([A-Z][a-z]*)(\d+)', node_name)
        op = op_temp[0][0]
        if op in ['Plus', 'Minus', 'Uminus', 'Times', 'Divide', 'Mod']:
            tpe_ = 5
        elif op in ['Mux', 'Cond', 'Case']:
            tpe_ = 6
        elif op == 'Concat':
            tpe_ = 7
        elif op in ['And', 'Land','Uand', 'Or', 'Lor','Uor', 'Xor', 'Uxor', 'Unot', 'Ulnot']:
            tpe_ = 8
        elif op in ['Eq', 'GreaterEq', 'LessEq', 'GreaterThan', 'Than', 'LessThan']:
            tpe_ = 9
        elif op in ['Sra', 'Srl', 'Sla', 'Sll']:
            tpe_ = 10
        else:
            print(op)
            assert False
    elif node_tpe_ori in ['Concat', 'Repeat']:
        tpe_ = 7
    elif node_tpe_ori in ['Constant']:
        tpe_ = 11
    # else:
    #     print(node_tpe_ori)
    #     assert False
    
    return tpe_

def run_one_design(design):
    print('Current Design: ', design)
    with open (f"../{cmd}/{design}_{cmd}.pkl", 'rb') as f:
        g = pickle.load(f)
    g_nx = nx.DiGraph(g)

    with open(f"../{cmd}/{design}_{cmd}_node_dict.pkl", 'rb') as f:
        node_dict = pickle.load(f)

    vec = [0 for i in range(12)]
    
    for node in g_nx.nodes():
        tpe = get_node_tpe(node, node_dict)
        vec[tpe] += 1
    vec = vec[1:]
    print(vec)

    with open (f"./{cmd}/{design}_feat.json", 'w') as f:
        json.dump(vec, f)

if __name__ == '__main__':
    global cmd
    cmd = "ori"


    with open("../../json/design_lst/design_lst.json", 'r') as f:
        design_lst = json.load(f)
    
    # design_lst = ['b20']

    for design in design_lst:
        run_one_design(design)