import os, time, json, re, random
from multiprocessing import Pool

def vlg_clean(file):
    file_tmp = file + ".tmp"
    os.system("cp {0} {1}".format(file, file_tmp))
    os.remove(file)
    with open(file_tmp, "r") as f:
        lines = f.readlines()
        with open(file, "a+") as f_tmp:
            for line in lines:
                line = re.sub(r'\(\*(.*)\*\)', '', line)
                if line.strip():
                    f_tmp.writelines(line)
    os.remove(file_tmp)

def transform_one_ep(design, ep, cur_design_idx):
    design_ori_dir = f"../ori/vlg/{design}/"
    design_pos_dir = f"../pos/vlg/{design}/"
    # design_neg_dir = f"../neg/vlg/{design}/"
    # design_neg_graph_dir = f"../neg/graph/{design}/"

    if not os.path.exists(design_pos_dir):
        os.makedirs(design_pos_dir)

    # if not os.path.exists(design_neg_dir):
    #     os.makedirs(design_neg_dir)
    # if not os.path.exists(design_neg_graph_dir):
    #     os.makedirs(design_neg_graph_dir)

    # if os.path.exists(f"{design_neg_dir}/{ep}.v"):
    #     os.remove(f"{design_neg_dir}/{ep}.v")
    # if os.path.exists(f"{design_neg_graph_dir}/{ep}_neg.pkl"):
    #     os.remove(f"{design_neg_graph_dir}/{ep}_neg.pkl")
    # if os.path.exists(f"{design_neg_graph_dir}/{ep}_neg_node_dict.pkl"):
    #     os.remove(f"{design_neg_graph_dir}/{ep}_neg_node_dict.pkl")
    #====== Postive Transformation ======#
    #### 1. transformation commands ####
    trans1 = "opt_expr;\n"
    trans2 = "opt_merge;\n"
    trans3 = "opt_reduce;\n"
    # trans4 = "abc -script abc.ys;\n"

    #### 2. script generation ####
    with open(f"./tranform_{design}_{ep}.ys", 'w') as f:
        line = f"read_verilog -sv /home/coguest5/hdl_fusion/data_collect/dataset/ori/vlg/{design}/{ep}.v\n"
        f.writelines(line)
        line = f"hierarchy -check -top coi\nproc\n"
        f.writelines(line)
        f.writelines(trans1)
        f.writelines(trans2)
        f.writelines(trans3)
        # f.writelines(trans4)
        f.writelines("opt_clean;\n")
        line = f"write_verilog /home/coguest5/hdl_fusion/data_collect/dataset/pos/vlg/{design}/{ep}.v\n"
        f.writelines(line)
    
    os.system(f"yosys -s tranform_{design}_{ep}.ys")
    vlg_clean(f"/home/coguest5/hdl_fusion/data_collect/dataset/pos/vlg/{design}/{ep}.v")
    os.remove(f"tranform_{design}_{ep}.ys")
    
    # #====== Negative Transformation ======#
    # #### 1. Random Sample ####
    # neg_design_idx = random.randint(0, len(design_lst)-1)
    # while neg_design_idx == cur_design_idx:
    #     neg_design_idx = random.randint(0, len(design_lst)-1)
    # assert neg_design_idx != cur_design_idx
    # for root, dirs, files in os.walk(f"../ori/graph/{design_lst[neg_design_idx]}/"):
    #     neg_ep_idx = random.randint(0, len(files)-1)
    #     print(neg_ep_idx)
    #     neg_ep = files[neg_ep_idx]
    #     print(neg_ep)
    #     print(root)
    #     neg_ep_name = neg_ep.split(".")[0]
    #     print(neg_ep_name)
    #     os.system(f"ln -s {root}/{neg_ep} /home/coguest5/hdl_fusion/data_collect/dataset/neg/vlg/{design}/{ep}.v")
    #     os.system(f"ln -s ../ori/graph/{design_lst[neg_design_idx]}/{neg_ep_name}_ori.pkl /home/coguest5/hdl_fusion/data_collect/dataset/neg/graph/{design}/{ep}_neg.pkl")
    #     os.system(f"ln -s ../ori/graph/{design_lst[neg_design_idx]}/{neg_ep_name}_ori_node_dict.pkl /home/coguest5/hdl_fusion/data_collect/dataset/neg/graph/{design}/{ep}_neg_node_dict.pkl")
    #     break
    # print(neg_design_idx)

if __name__ == '__main__':

    

    global design_lst
    with open("../json/design_lst/design_lst.json", 'r') as f:
        design_lst = json.load(f)
    
    for idx, design in enumerate(design_lst):
        with open (f"../json/{design}.json", 'r') as f:
            reg_lst = json.load(f)

        output_dir = f'../ori/graph/{design}/'
        if not os.path.exists(output_dir):
            os.makedirs(output_dir)

        for ep in reg_lst[design]:
            print(design + ' ' + ep)
            try:
                transform_one_ep(design, ep, idx)
            except:
                pass

    
    

    



