from __future__ import absolute_import
from __future__ import print_function
import sys
import os, time, json, re, pickle
from optparse import OptionParser
import networkx as nx
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
import pyverilog
from pyverilog.vparser.parser import parse
from AST_analyzer import AST_analyzer
from AST_analyzer import *

def align_ep(design_name):
    print('Current Design: ', design_name)
    if os.path.exists(f"../json/{design_name}.json"):
        return

    save_dir = f"../netlist_data/"
    with open (f"{save_dir}/{design_name}_graph.pkl", 'rb') as f:
        g = pickle.load(f)
    with open (f"{save_dir}/{design_name}_node_dict.pkl", 'rb') as f:
        node_dict = pickle.load(f)
    with open (f"{save_dir}/{design_name}_dff_set.pkl", 'rb') as f:
        dff_set = pickle.load(f)


    ### align the endpoint
    ep_lst_path = f"/home/coguest5/rtl_repr/data_collect/dataset/json/{design_name}.json"
    with open(ep_lst_path, 'r') as f:
        ep_lst_dict = json.load(f)
    ep_lst = ep_lst_dict[design_name]
    design_dict = {}
    for ep in ep_lst:
        ep_dict = run_one_ep(ep, dff_set)
        design_dict.update(ep_dict)
    
    # print(design_dict)
    with open(f"../json/{design_name}.json", 'w') as f:
        json.dump(design_dict, f, indent=4)
 
def run_one_ep(ep, dff_set):
    ep_dff_lst = []
    for dff in dff_set:
        re_reg = re.findall(r"^{0}_reg$".format(ep), dff)
        re_ptr = re.findall(r"^{0}_reg_(\d+)_$".format(ep), dff)
        re_ps = re.findall(r"^{0}_reg_(\d+)_(\d+)_$".format(ep), dff)
        if re_reg:
            ep_dff_lst.append(dff)
        if re_ptr:
            ep_dff_lst.append(dff)
        if re_ps:
            assert False
    
    ep_dict = {}
    ep_dict[ep] = ep_dff_lst
    if not ep_dff_lst:
        print(ep)
        # assert False

    return ep_dict


if __name__ == '__main__':
    ### TODO: p7
    design_js_path = "/home/coguest5/rtl_repr/data_collect/dataset/json/design_lst/design_lst_p7.json"
    with open (design_js_path, 'r') as f:
        design_lst = json.load(f)
    for design in design_lst:
        align_ep(design)

    # align_ep('b14')