from __future__ import absolute_import
from __future__ import print_function
import sys
import os, time, json, re, pickle
from optparse import OptionParser
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
import pyverilog
from pyverilog.vparser.parser import parse
from AST_analyzer import *
from AST_analyzer import AST_analyzer
from multiprocessing import Pool

def run_one_design(design_name):
    print('Current Design:', design_name)
    design_dir = f'/home/coguest5/rtl_repr/data_collect/dataset_net/data/{cmd}/{design_name}.syn.v'
    filelist = [design_dir]

    for f in filelist:
        if not os.path.exists(f):
            raise IOError("file not found: " + f)

    ast, directives = parse(filelist)
    print('Verilog2AST Finish!')
    ast_analysis = AST_analyzer(ast)
    
    ast_analysis.AST2Graph(ast, cmd, design_name)
    g, node_dict, _ = ast_analysis.graph2dff_lst(design_name)

    save_dir = f"/home/coguest5/rtl_repr/data_collect/dataset_net/net_graph/{cmd}"
    with open (f"{save_dir}/{design_name}_graph.pkl", 'wb') as f:
        pickle.dump(g, f)
    with open (f"{save_dir}/{design_name}_node_dict.pkl", 'wb') as f:
        pickle.dump(node_dict, f)



if __name__ == '__main__':
    global cmd
    cmd = "CMD_NAME_HERE"

    run_one_design("DESIGN_NAME_HERE")