# ICLR 2025

Code submission for 'Rethinking Graph Super-Resolution: Dual Frameworks for Topological Fidelity'.

W propose two novel frameworks to tackle existing limitations of graph super-resolution models: (1) They use simple linear algebraic trick to increase the number to increase the number of nodes, violating the graph structure of the problem. (2) They use GNNs based on node representation learning which has limited capacity to model edge features. 

To solve these, we propose two frameworks: (1) Bi-SR (Bipartite Graph Super-Resolution), and (2) DEFEND (Dual Graphs for Edge Feature learning and Detection). We perform extensive theoretical and empirical analysis to evaluate these frameworks. 

The experiments are done across three sets of datasets: (1) Physics-inspired dummy dataset, (2) Traditional graph simulation datasets, and (3) Brain Graph Datasets. Please follow below steps to reproduce these experiments:

### Set-up

1. Create virtual environment for the project:

    ```python3 -m venv venv```
2. Activate virtual environment:

    ```source venv/bin/activate```
3. Install packages


    ```pip install -r requirements.txt```


### Physics-inspired dummy dataset

The configurations for these experiments are stored under  `configs/physics.py`. Please change them as required and run:

```
python3 runs/physics.py
```

### Simulated datasets

The configurations for these experiments are stored under  `configs/simulated.py`. Please specify the correct `DATASET_TYPE` there and change other configs as required before running:

```
python3 runs/simulated.py
```

### Brain Graph Dataset

Please prepare and download the csv files for LR-HR brain graphs from the SLIM dataset and store as `data/lr_train.csv` and `data/lr_train.csv`. The configurations for these experiments are stored under  `configs/brain.py`. Please change the configs as required before running:
```
python3 runs/brain/main.py
```

To run our adapted version of IMANGraphNet, please use:

```
python3 runs/brain/iman_adpated.py
```

To run our proposed AutoEncoder baseline, please use:

```
python3 runs/brain/autoencoder.py
```
