import ml_collections

def get_config():
    config = ml_collections.ConfigDict()
    config.discount = 0.99
    config.alpha_multiplier = 20.0
    config.use_automatic_entropy_tuning = False
    config.target_entropy = 0.0
    config.policy_lr = 3e-4
    config.q_lr = 3e-4
    config.v_lr = 3e-4
    config.optimizer_type = 'adam'
    config.soft_target_update_rate = 5e-3
    config.target_update_period = 1
    config.policy_arch = '256-256'
    config.q_arch = '256-256'
    config.expectile = 0.7
    config.t = 3.0
    config.change_beta = 50000
    config.start_beta = 10
    config.end_beta = 10
    config.beta_rate = 0
    config.dropout_rate = None
    config.p_dropout = None
    return config