import absl.app
import absl.flags

from utils import *
from rl_train import rl_train
from agent.test import test

FLAGS_DEF = define_flags_with_default(
    env='halfcheetah-medium-v2',
    #halfcheetah-random-v2,,halfcheetah-medium-replay-v2,halfcheetah-medium-expert-v2,
    #walker2d-random-v2,walker2d-medium-v2,walker2d-medium-replay-v2,walker2d-medium-expert-v2,
    #hopper-random-v2,hopper-medium-v2,hopper-medium-replay-v2,hopper-medium-expert-v2
    #pen-human-v0,hammer-human-v0,door-human-v0,relocate-human-v0
    #pen-cloned-v0,hammer-cloned-v0,door-cloned-v0,relocate-cloned-v0
    #kitchen-complete-v0,kitchen-partial-v0,kitchen-mixed-v0
    max_traj_length=1000,
    seed= 123,
    device='cuda',
    save_model=False,
    batch_size=256,

    reward_scale=1.0,
    reward_bias=0.0,

    orthogonal_init=False,
    policy_log_std_multiplier=1.0,
    policy_log_std_offset=-1.0,

    n_epochs=1000,#1000
    n_train_step_per_epoch=1000,#1000
    eval_period=10,#10
    eval_n_trajs=5,
    logdir_prefix = './log/',
    update_freq = 1,
    opt_class = 'adam',
    exp_name = 'sac',

    model_epochs = 300,

    load_path = '',

    get_dataset = False,
    max_size = 1000000,
    data_path = './dataset/',
)
config_flags.DEFINE_config_file('config','default.py','File path to the training hyperparameter configuration.',lock_config=False)

def main(argv):
    FLAGS = absl.flags.FLAGS
    #variant = get_user_flags(FLAGS,FLAGS_DEF)
    rl_train(FLAGS)

if __name__ == '__main__':
    absl.app.run(main)